// Case-insensitive collation for ISO 8859-1.
// DWF 1999-10-27

// This collation follows the partial ordering formed by Unicode Level
// 1 weights for alphabetic characters, except for the ligature 
// which should be replaced by ss.  All non-alphabetic characters
// retain their ASCII ordering.

// Reference:
//   http://www.unicode.org/unicode/reports/tr10/basekeys.txt

// For  you have to look in the "compound keys" file under
// LATIN SMALL LETTER SHARP S:
//   http://www.unicode.org/unicode/reports/tr10/compkeys.txt

// The actual values assigned are not from Unicode but are a relic from
// the previous version of this collation.

// Equivalence classes:
// 256  Aa
// 263  
// 264  Bb
// 265  Cc
// 266  
// 267  Dd
// 268  
// 269  Ee
// 274  Ff
// 275  Gg
// 276  Hh
// 277  Ii
// 282  Jj
// 283  Kk
// 284  Ll
// 285  Mm
// 286  Nn
// 288  Oo
// 294  
// 295  Pp
// 296  Qq
// 297  Rr
// 298  Ss
// 299  
// 300  Tt
// 302  Uu
// 307  Vv
// 308  Ww
// 309  Xx
// 310  Yy
// 313  Zz
// 315  

int collation[256] = {
    0,  //
    1,  //
    2,  //
    3,  //
    4,  //
    5,  //
    6,  //
    7,  //
    8,  //
    9,  //
   10,  //
   11,  //
   12,  //
   13,  //
   14,  //
   15,  //
   16,  //
   17,  //
   18,  //
   19,  //
   20,  //
   21,  //
   22,  //
   23,  //
   24,  //
   25,  //
   26,  //
   27,  //
   28,  //
   29,  //
   30,  //
   31,  //
   32,  //
   33,  // !
   34,  // "
   35,  // #
   36,  // $
   37,  // %
   38,  // &
   39,  // '
   40,  // (
   41,  // )
   42,  // *
   43,  // +
   44,  // ,
   45,  // -
   46,  // .
   47,  // /
   48,  // 0
   49,  // 1
   50,  // 2
   51,  // 3
   52,  // 4
   53,  // 5
   54,  // 6
   55,  // 7
   56,  // 8
   57,  // 9
   58,  // :
   59,  // ;
   60,  // <
   61,  // =
   62,  // >
   63,  // ?
   64,  // @
  256,  // A
  264,  // B
  265,  // C
  267,  // D
  269,  // E
  274,  // F
  275,  // G
  276,  // H
  277,  // I
  282,  // J
  283,  // K
  284,  // L
  285,  // M
  286,  // N
  288,  // O
  295,  // P
  296,  // Q
  297,  // R
  298,  // S
  300,  // T
  302,  // U
  307,  // V
  308,  // W
  309,  // X
  310,  // Y
  313,  // Z
   91,  // [
   92,  // backslash
   93,  // ]
   94,  // ^
   95,  // _
   96,  // `
  256,  // a
  264,  // b
  265,  // c
  267,  // d
  269,  // e
  274,  // f
  275,  // g
  276,  // h
  277,  // i
  282,  // j
  283,  // k
  284,  // l
  285,  // m
  286,  // n
  288,  // o
  295,  // p
  296,  // q
  297,  // r
  298,  // s
  300,  // t
  302,  // u
  307,  // v
  308,  // w
  309,  // x
  310,  // y
  313,  // z
  123,  // {
  124,  // |
  125,  // }
  126,  // ~
  127,  //
  128,  //
  129,  //
  130,  //
  131,  //
  132,  //
  133,  //
  134,  //
  135,  //
  136,  //
  137,  //
  138,  //
  139,  //
  140,  //
  141,  //
  142,  //
  143,  //
  144,  //
  145,  //
  146,  //
  147,  //
  148,  //
  149,  //
  150,  //
  151,  //
  152,  //
  153,  //
  154,  //
  155,  //
  156,  //
  157,  //
  158,  //
  159,  //
  160,  //
  161,  // 
  162,  // 
  163,  // 
  164,  // 
  165,  // 
  166,  // 
  167,  // 
  168,  // 
  169,  // 
  170,  // 
  171,  // 
  172,  // 
  173,  // 
  174,  // 
  175,  // 
  176,  // 
  177,  // 
  178,  // 
  179,  // 
  180,  // 
  181,  // 
  182,  // 
  183,  // 
  184,  // 
  185,  // 
  186,  // 
  187,  // 
  188,  // 
  189,  // 
  190,  // 
  191,  // 
  256,  // 
  256,  // 
  256,  // 
  256,  // 
  256,  // 
  256,  // 
  263,  // 
  266,  // 
  269,  // 
  269,  // 
  269,  // 
  269,  // 
  277,  // 
  277,  // 
  277,  // 
  277,  // 
  268,  // 
  286,  // 
  288,  // 
  288,  // 
  288,  // 
  288,  // 
  288,  // 
  215,  // 
  294,  // 
  302,  // 
  302,  // 
  302,  // 
  302,  // 
  310,  // 
  315,  // 
  299,  // 
  256,  // 
  256,  // 
  256,  // 
  256,  // 
  256,  // 
  256,  // 
  263,  // 
  266,  // 
  269,  // 
  269,  // 
  269,  // 
  269,  // 
  277,  // 
  277,  // 
  277,  // 
  277,  // 
  268,  // 
  286,  // 
  288,  // 
  288,  // 
  288,  // 
  288,  // 
  288,  // 
  247,  // 
  294,  // 
  302,  // 
  302,  // 
  302,  // 
  302,  // 
  310,  // 
  315,  // 
  310   // 
};
