/*  xxWindow  Abstract class for all XTide windows implementing dismiss().
    Last modified 1998-04-10

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xtide.hh"

xxWindow::xxWindow (xxTideContext *in_tidecontext, xxContext *in_xxcontext,
int needbox, XtGrabKind in_grabkind) {
  xtidecontext = in_tidecontext;
  xtidecontext->root->dup (this);
  mypopup = new xxContext (in_xxcontext, in_grabkind);
  Arg args[2] =  {
    {XtNbackground, (XtArgVal)mypopup->pixels[Colors::background]},
    {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]}
  };
  XtSetValues (mypopup->manager, args, 2);
  XtAddEventHandler (mypopup->manager, NoEventMask, True,
    xxWindowCloseHandler, (XtPointer)this);
  if (needbox) {
    Widget boxwidget = XtCreateManagedWidget ("", boxWidgetClass,
      mypopup->manager, args, 2);
    box = new xxContext (mypopup, boxwidget);
  } else
    box = NULL;
  is_title_screen = noclose = 0;
}

void xxWindowCloseHandler (Widget w, XtPointer client_data,
			   XEvent *event, Boolean *continue_dispatch) {
  xxWindow *f = (xxWindow *)client_data;
  if (f->noclose)
    return;
  switch (event->type) {
  case ClientMessage:
    {
      XClientMessageEvent *ev = (XClientMessageEvent *) event;
      // Window manager close.
      if (ev->message_type == f->mypopup->protocol_atom &&
	  ev->data.l[0] == f->mypopup->kill_atom)
        f->dismiss();
    }
    break;
  default:
    ;
  }
}

xxWindow::~xxWindow() {
  mypopup->unrealize();
  xtidecontext->root->release (this);
  if (box)
    delete box;
  delete mypopup;
}

void xxWindow::global_redraw() {
  Arg args[2] =  {
    {XtNbackground, (XtArgVal)mypopup->pixels[Colors::background]},
    {XtNforeground, (XtArgVal)mypopup->pixels[Colors::foreground]}
  };
  XtSetValues (mypopup->manager, args, 2);
  if (box)
    XtSetValues (box->manager, args, 2);
}
