
#include <stdlib.h>
#include "lispassert.h"

inline CArrayGrowerBase::CArrayGrowerBase(int aItemSize, int aGranularity) 
    : iItemSize(aItemSize),iNrItems(0),
      iArray(NULL),iNrAllocated(0) ,iGranularity(aGranularity),
      iArrayOwnedExternally(LispFalse)
    {
    }


inline void CArrayGrowerBase::SetNrItems(int aNrItems)
{
    LISPASSERT(aNrItems<=iNrAllocated);
    iNrItems = aNrItems;
}

inline LispChar* CArrayGrowerBase::BaseItem(int aIndex)
{
    LISPASSERT(aIndex>=0);
    LISPASSERT(aIndex<iNrItems);
    return iArray + aIndex*iItemSize;
}


inline LispBoolean CArrayGrowerBase::ArrayOwnedExternally()
{
    return iArrayOwnedExternally;
}

template <class T> 
inline CArrayGrower<T>::CArrayGrower(int aGranularity)
    :CArrayGrowerBase(sizeof(T),aGranularity) 
    { 
    }

template <class T> 
inline T& CArrayGrower<T>::Item(const int aIndex) 
    {
    return *(T*)BaseItem(aIndex);
    }

template <class T> 
inline T& CArrayGrower<T>::operator[](const int aIndex) 
    {
    return Item(aIndex);
    }

template <class T> 
inline int CArrayGrower<T>::Append(T aValue)
    {
    return BaseAppend((LispChar*)&aValue);
    }

template <class T> 
inline void CArrayGrower<T>::Move(int aSrcIndex, int aTrgIndex)
    {
    T toMove = Item(aSrcIndex);
    MoveBlock(aSrcIndex, aTrgIndex);
    Item(aTrgIndex) = toMove;
    }

template<class T>
inline void DestructArray(CArrayGrower<T>& aArray)
{
  int i;
  for (i=0;i<aArray.NrItems();i++)
  {
    delete aArray[i];
    aArray[i] = NULL;
  }
}

template<class T>
inline void CArrayGrower<T>::Insert(int aIndex, T& aObj)
{
    GrowTo(iNrItems+1);
    int i;

    for (i=iNrItems-2;i>=aIndex;i--)
    {
        Item(i+1) = Item(i);
    }
    Item(aIndex) = aObj;
}

template<class T>
inline void CArrayGrower<T>::SetExternalArray(T* aArray, LispInt aNrItems)
{
    LISPASSERT(iArray == NULL || iArrayOwnedExternally == LispTrue);
    iArray = aArray;
    iNrItems = aNrItems;
    iArrayOwnedExternally = LispTrue;
}


