
/* example1 : just meant to show that triage works. Renders some
 * triangles.
 */

#include <stdio.h>

#include "targagrabber.h"
#include "matrix.h"
#include "triage.h"
#include "render.h"

#define WIDTH  320
#define HEIGHT 200

CTexture2d texture(WIDTH,HEIGHT);
CTexture2d depth(WIDTH,HEIGHT);
CTriage    triage(texture,depth);

void DoTriangle(PlatInt x0, PlatInt y0, PlatInt z0, PlatPixel aColor0,
                PlatInt x1, PlatInt y1, PlatInt z1, PlatPixel aColor1,
                PlatInt x2, PlatInt y2, PlatInt z2, PlatPixel aColor2)
{
  CVector v0(IntToFixed(x0),IntToFixed(y0),IntToFixed(z0));
  CVector v1(IntToFixed(x1),IntToFixed(y1),IntToFixed(z1));
  CVector v2(IntToFixed(x2),IntToFixed(y2),IntToFixed(z2));
  triage.Triangle(v0,aColor0, v1,aColor1, v2,aColor2);
}

void DoTri(PlatInt z, PlatInt angle)
{
    triage.Transform().PushMatrix();
    triage.RotateZ(angle);
    triage.Translate(IntToFixed(WIDTH>>1),IntToFixed(HEIGHT>>1),0);

    DoTriangle(-10, -20, z,Pixel(255,0,0,100),
               10,   0, z,Pixel(255,0,0,100),
               -10,  20, z,Pixel(255,0,0,100));
    triage.Transform().PopMatrix();
}

int main(void)
{
    Clear(texture, Pixel(0,0,0,0));
    Clear(depth, PlatMaxDepth);

    triage.SetFlag(KFlagLessDepth);

    {
      CVector tl(IntToFixed(60), IntToFixed(30), IntToFixed(0));
      CVector br(IntToFixed(10), IntToFixed(10), IntToFixed(0));
      triage.Line(tl, Pixel(0,0,255,0), br, Pixel(0,255,0,255));
    }

    DoTriangle(40, 10, 10,Pixel(0,0,255,255),
               10, 40, 10,Pixel(0,255,0,255),
               40, 70, 10,Pixel(255,0,0,255));

    DoTriangle(50, 10, 12,Pixel(0,0,255,255),
               20, 40, 12,Pixel(0,255,0,255),
               50, 70, 12,Pixel(255,0,0,255));

    CMatrix m;
    IdentityMatrix(m);
    Scale(m, IntToFixed(3),IntToFixed(3),IntToFixed(3));
    triage.Transform().Apply(m);
    {
        int i;
        for (i=0;i<5;i++)
            DoTri(5-i,(HalfPi>>1)+i*10);
    }

    SaveAsTarga("example1.tga",&texture[0],
                texture.Width(), texture.Height());

    system("xv example1.tga &");
    return 0;
}

