
/* example4 : Show off some post processing to perform an implicit
 * plot of a 2d function.
 */


// examples4.cpp materials.h geometry.h
//
// CTriage constructor: iRenderFlags not reset.


#include <stdio.h>
#include "triage.h"

#include "render.h"
#include "inliners.h"
#include "pixels.h"
#include "targagrabber.h"
#include "matrix.h"
#include "processing.h"
#include "geometry.h"
#include "materials.h"

#include "hershey.h"


#define WIDTH  400
#define HEIGHT 400

CTexture2d texture(WIDTH,HEIGHT);
CTexture2d depth(WIDTH,HEIGHT);
CTriage    triage(texture,depth);



int main(void)
{
    Clear(texture, Pixel(255,255,255,0));
    Clear(depth, 1000);

    
    SaveAsTarga("example6.tga",&texture[0],
                texture.Width(), texture.Height());

    system("xv example6.tga");
   
    return 0;
}

