
#ifndef __geometry_h__
#define __geometry_h__

#include "triage.h"

/** DrawSphere : draw a sphere. Class C should be one of the material
 *  classes defined in materials.h.
 */
template<class C>
void DrawSphere(CTriage& aTriage, Fixed radius,const C& col,PlatInt steps)
{

    CVector *vv[2];
    vv[0] = new CVector[steps];
    vv[1] = new CVector[steps];
    CVector *nn[2];
    nn[0] = new CVector[steps];
    nn[1] = new CVector[steps];

    int ncur=0;
    int x,y;
    for (y=0;y<steps;y++)
    {
        for (x=0;x<steps;x++)
        {
            PlatInt u = ((NrTrigBins-1)*x)/(steps-1);
            PlatInt v = (((NrTrigBins-1)>>1)*y)/(steps-1);
            vv[ncur][x].xf[0] = FixedMul(radius,FixedMul(aTriage.Trig().Sin(u),aTriage.Trig().Sin(v)));
            vv[ncur][x].xf[1] = FixedMul(radius,FixedMul(aTriage.Trig().Cos(u),aTriage.Trig().Sin(v)));
            vv[ncur][x].xf[2] = FixedMul(radius,aTriage.Trig().Cos(v));
            vv[ncur][x].xf[3] = FixedOne;

            nn[ncur][x].xf[0] = FixedMul(aTriage.Trig().Sin(u),aTriage.Trig().Sin(v));
            nn[ncur][x].xf[1] = FixedMul(aTriage.Trig().Cos(u),aTriage.Trig().Sin(v));
            nn[ncur][x].xf[2] = aTriage.Trig().Cos(v);
            nn[ncur][x].xf[3] = FixedOne;

        }
        if (y>0)
        {
          for (x=0;x<steps-1;x++)
          {
              PlatPixel c0=0,c1=0,c2=0,c3=0;
              c0=col.Color(vv[1-ncur][x+0],nn[1-ncur][x+0]);
              c1=col.Color(vv[1-ncur][x+1],nn[1-ncur][x+1]);
              c2=col.Color(vv[ncur]  [x+0],nn[ncur]  [x+0]);
              c3=col.Color(vv[ncur]  [x+1],nn[ncur]  [x+1]);
              aTriage.Quad(vv[ncur]  [x+0], c2,
                           vv[ncur]  [x+1], c3,
                           vv[1-ncur][x+0], c0,
                           vv[1-ncur][x+1], c1);

          }
        }
        ncur = 1-ncur;
    }
}


#endif

