
#ifndef __interpolator_h__
#define __interpolator_h__

#include "triagetypes.h"
#include "fixed.h"

typedef enum
{
    KPivotX,
    KPivotY
} EInterpolatorPivot;

/** CInterpolator : two-dimensional interpolation.
 */
class CInterpolator
{
public:
    void Initialize(PlatInt x0, PlatInt y0, PlatInt x1, PlatInt y1);
    inline void Get(PlatInt& x,PlatInt& y) {x=iX; y=iY;};
    void Next();
    inline PlatInt NrSteps() {return iNrSteps;};
private:
    PlatInt iX0;
    PlatInt iY0;
    PlatInt iX1;
    PlatInt iY1;
    PlatInt iX;
    PlatInt iY;
    PlatInt iDeltaX;
    PlatInt iDeltaY;
    PlatInt iStepX;
    PlatInt iStepY;
    PlatInt iNrSteps;
    EInterpolatorPivot iPivot;
    PlatInt e;
    PlatInt e1;
    PlatInt e2;
};


/** CSingleInterpolate : interpolate in steps from from to to,
 * calculating a weight from 0 to FixedOne in the process.
 */
class CSingleInterpolate
{
public:
    inline void Initialize(PlatInt from, PlatInt to)
    {
        iWeight=0;
        iCount=0;
        iCurrent=from;
        iNr=to-from;
        iStep=1;
        if (iNr<0)
        {
            iNr=-iNr;
            iStep=-1;
        }
        iDone=-iNr;
        if (iNr==0)
            iNr=1;
    };
    inline void Next()
    {
        iCount+=0x10000;
        iWeight+=(iCount/iNr);
        iCount%=iNr;
        iCurrent+=iStep;
        iDone++;
    };
    inline PlatInt CurrentIndex()
    {
        return iCurrent;
    }
    inline PlatInt CurrentValue()
    {
        return iWeight;
    }
    inline PlatInt Done()
    {
        return iDone;
    }

private:
    PlatInt   iWeight;
    PlatInt   iCount;
    PlatInt   iNr;
    PlatInt   iStep;
    PlatInt   iCurrent;
    PlatInt   iDone;
};

inline PlatInt Interpolate(PlatInt x0,PlatInt x1, PlatInt weight)
{
    return ((0x10000-weight)*x0 + weight*x1+0x8000)>>16;
}



#endif

