// UTILS.C
//
// Copyright Ayal Zwi Pinkus 1998
//


#include <stdio.h>
#include <stdlib.h>
#include "assert.h"
#include "triagetypes.h"
#include "pixels.h"
#include "targagrabber.h"

static void SaveAsTargaAux(char* aFileName,unsigned char* buf,int width, int height);

void SaveAsTarga(char* aFileName,PlatPixel* buf,int width, int height)
{
    int nr=width*height;
    unsigned char* buffer = (unsigned char*)malloc(3*nr);
    int i,j;

    for (i=0;i<height;i++)
        for (j=0;j<width;j++)
        {
            PlatInt index, reverse;
            index =   j+width*i;
            reverse = j+width*(height-i-1);
            buffer[3*index+2] = Red  (buf[reverse]);
            buffer[3*index+1] = Green(buf[reverse]);
            buffer[3*index+0] = Blue (buf[reverse]);
        }
    SaveAsTargaAux(aFileName,buffer,width, height);
    free(buffer);
}


static void SaveAsTargaAux(char* aFileName,unsigned char* buf,int width, int height)
{


    FILE *fo=fopen(aFileName,"wb");
    if (fo)
    {
        int count=width * height;
        assert(count<1024*1024);

        //write file header
        {
            char c;

            c=0;
            fwrite(&c,1,1,fo);   // ID length
            fwrite(&c,1,1,fo);   // Color map type
            c=0x02;
            fwrite(&c,1,1,fo);   // Image type

            c=0;
            fwrite(&c,1,1,fo);   // Color map specification
            fwrite(&c,1,1,fo);
            fwrite(&c,1,1,fo);
            fwrite(&c,1,1,fo);
            fwrite(&c,1,1,fo);

            // Image spec:
            c=0;
            fwrite(&c,1,1,fo);  // x on screen
            fwrite(&c,1,1,fo);

            fwrite(&c,1,1,fo);  // y on screen
            fwrite(&c,1,1,fo);

            fwrite(&width,2,1,fo);
            fwrite(&height,2,1,fo);

            c=24;
            fwrite(&c,1,1,fo);   // bits per pixel

            c=0;
            fwrite(&c,1,1,fo);  // descriptor (bits 0-3 specify the alpha channel nrbits!)
        }

        // write pixels
        if (count)
            fwrite(buf,3,count,fo);
//            fwrite(buf,3,count,fo);

        // Finished. Now close file
        fclose(fo);
    }
}



