/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: details.c,v 0.5 1999/08/16 23:42:44 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

#define STRING(x) ((x)?(x):"")

void
displaytext (int x, int y, int height, int width, char *s)
{
  int idx, z;

  attrset (COLOR_PAIR (CP_INFOVAL));

  if (!s)
    return;

  while (*s && width)
    {
      if (strlen (s) > height)
	{
	  idx = 0;
	  for (z = height; (z > height - 10) && (idx == 0); z--)
	    if (s[z] == ' ' || s[z] == '\t')
	      idx = z;
	  if (idx == 0)
	    idx = height;
	}
      else
	{
	  idx = strlen (s);
	}

      mvprintw (y, x, "%*.*s", idx, idx, s);
      printw ("%*.*s", height - idx, height - idx, "");
      while (s[idx] == ' ')
	idx++;
      s += idx;
      y++;
      width--;
    }
  while (width--)
    mvprintw (y++, x, "%*.*s", height, height, "");
}

static void
draw_detailscreen (struct app *app)
{
  attrset (COLOR_PAIR (CP_HEADER));
  mvprintw (0, 0, "appindex browser                                             ");
  mvprintw (0, COLS - (strlen (gendate) + 6), "Date: %s", gendate);

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (1, (COLS - strlen (app->name)) / 2, "%s", app->name);

  displaytext (0, 2, COLS, 2, app->oneliner);

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (5, 0, "Version:     ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  if (app->stable)
    if (app->stable[0])
      printw ("stable %s%s", STRING (app->stable),
	      app->devel ? app->devel[0] ? ", " : "" : "");
  if (app->devel)
    if (app->devel[0])
      printw ("devel %s", STRING (app->devel));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (6, 0, "License:     ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->license));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (7, 0, "Category:    ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->cat->name));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (8, 0, "Author:      ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->author));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (9, 0, "Co-author:   ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->coauthor));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (10, 0, "Homepage:    ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->homepage));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (11, 0, "Download:    ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->download));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (12, 0, "DEB package: ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->deb));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (13, 0, "RPM package: ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->rpm));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (14, 0, "Freshmeat:   ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->link));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (15, 0, "Dependancy:  ");
  attrset (COLOR_PAIR (CP_INFOVAL));
  printw ("%s", STRING (app->dependancy));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (16, 0, "Description: ");
  attrset (COLOR_PAIR (CP_INFOVAL));

  displaytext (13, 16, COLS - 14, LINES - 17, STRING (app->description));

  attrset (COLOR_PAIR (CP_KEY));
  mvprintw (LINES - 1, 0, "q,<bs>");
  attrset (COLOR_PAIR (CP_KEYTEXT));
  printw ("-back ");

  attrset (COLOR_PAIR (CP_KEY));
  printw ("h");
  attrset (COLOR_PAIR (CP_KEYTEXT));
  printw ("-help ");

  attrset (COLOR_PAIR (CP_KEY));
  printw ("/");
  attrset (COLOR_PAIR (CP_KEYTEXT));
  printw ("-search ");

  attrset (COLOR_PAIR (CP_KEY));
  printw ("w");
  attrset (COLOR_PAIR (CP_KEYTEXT));
  printw ("-homepage ");

  attrset (COLOR_PAIR (CP_KEY));
  printw ("d");
  attrset (COLOR_PAIR (CP_KEYTEXT));
  printw ("-download ");

  attrset (COLOR_PAIR (CP_KEY));
  printw ("f");
  attrset (COLOR_PAIR (CP_KEYTEXT));
  printw ("-fm ");

  attrset (COLOR_PAIR (CP_KEY));
  printw ("r");
  attrset (COLOR_PAIR (CP_KEYTEXT));
  printw ("-rpm ");

  attrset (COLOR_PAIR (CP_KEY));
  printw ("e");
  attrset (COLOR_PAIR (CP_KEYTEXT));
  printw ("-deb ");

  attrset (COLOR_PAIR (CP_KEY));
  printw ("c");
  attrset (COLOR_PAIR (CP_KEYTEXT));
  printw ("-changelog");

  printw ("  ");
}

void
details (struct app *app)
{
  clear ();
  draw_detailscreen (app);
  refresh ();

  while (1)
    {
      switch (getch ())
	{
	case 'q':
	case 'Q':
	case KEY_BACKSPACE:
	case KEY_LEFT:
	  return;
	case 'h':
	case 'H':
	  run_man ();
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 12:
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case '/':
	  search ();
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'w':
	case 'W':
	  if (app->homepage[0])
	    run_browser (app->homepage);
	  else
	    error ("No homepage URL specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'd':
	case 'D':
	  if (app->download[0])
	    run_browser (app->download);
	  else
	    error ("No download URL specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'f':
	case 'F':
	  if (app->link[0])
	    run_browser (app->link);
	  else
	    error ("No freshmeat link URL specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'r':
	case 'R':
	  if (app->rpm[0])
	    run_browser (app->rpm);
	  else
	    error ("No .rpm package specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'e':
	case 'E':
	  if (app->deb[0])
	    run_browser (app->deb);
	  else
	    error ("No .deb package specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	case 'c':
	case 'C':
	  if (app->changelog[0])
	    run_browser (app->changelog);
	  else
	    error ("No changelog URL specified!");
	  clear ();
	  draw_detailscreen (app);
	  refresh ();
	  break;
	}			/* switch */
    }				/* while */
}				/* details */
