/*
	CATAM Part 1A/1B Computer Project

	library header file

	$Id: junk.h,v 1.1 1997/06/09 01:50:06 asm21 Exp $
	$Log: junk.h,v $
	Revision 1.1  1997/06/09 01:50:06  asm21
	First CVS commit
	
	Revision 1.1  1996/07/02 16:03:26  asm21
	Initial revision

	Revision 0.7  1996/05/02 04:25:50  asm21
	*** empty log message ***

	Revision 0.6  1996/04/21 20:20:18  asm21
	Added graph3d() and it's associated structures etc

	Revision 0.5  1996/04/06 17:17:18  asm21
	Added some GCC-specific attributes to the fatal function to improve
	optimisation

	Revision 0.4  1996/04/04 10:27:35  asm21
	Added extern "C" when compiling in C++, and included stdlib.h for definition
	of size_t.

	Revision 0.3  1996/04/03 17:44:28  asm21
	Added #ifndef __CATAM_H check so I can include from other header files

	Revision 0.2  1996/04/03 14:47:32  asm21
	Added decl for fatal function

	Revision 0.1  1996/04/03 13:29:10  asm21
	Amalgamated graph.h and ui.h; added decls for xmalloc/xrealloc

*/

#ifndef __JUNK_H
#define __JUNK_H

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NUMBER
#define NUMBER float
#endif

/* user interface functions */
int choosemenu(char *text[], char *title);

/* graphing functions */
struct graph_line 
{
  enum { GL_DATA, GL_LINE } type;
  char *title;
  union 
    {
      struct 
	{
	  unsigned npts;
	  NUMBER *x;
	  NUMBER *y;
	} data;
      char *line;
    } parms;
};
      
void graph(struct graph_line l[], int nlines);

struct graph_surface
{
  enum { GS_DATA, GS_SURFACE } type;
  char *title;
  union 
    {
      struct
	{
	  unsigned nxpts;
	  unsigned nypts;
	  NUMBER *x;
	  NUMBER *y;
	  NUMBER *z;
	} data;
      char *surface;
    } parms;
};

#define G3D_SURF 0x1
#define G3D_CONT 0x2
enum _3dgraphtypes { SURFACE_ONLY=G3D_SURF, CONTOURS_ONLY=G3D_CONT, BOTH=G3D_SURF | G3D_CONT };

void graph3d(struct graph_surface s[], int nsurfs, enum _3dgraphtypes type);
      
/* memory allocation */
void *xmalloc (size_t size);
void *xrealloc (void *ptr, size_t size);

/* exit with fatal error (also in lib-xmalloc.c) */
#ifdef __GNUC__
/* tell GCC more about the function, so it can optimise/debug better */
void fatal(char *fmt, ...) __attribute__ ((noreturn,format(printf,1,2)));
#else /* __GNUC__ */
void fatal(char *fmt, ...);
#endif /* __GNUC__ */

#ifdef __cplusplus
}
#endif

#endif /* __JUNK_H */
