/*
==============================================================================
	makeint.c
		桼 maketree ɷʥХʥեˤѴ
		1990/11/09/Fri	Yutaka MYOKI(Nagao Lab., KUEE)
		1991/01/08/Tue	Ver 1.00
==============================================================================
*/

#include "chadic.h"

/* trans.c */
extern void trans();

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<usage>: print usage on "stderr", and "exit"
------------------------------------------------------------------------------
*/

static void usage()
{
    fprintf(stderr, "usage: makeint [ -q ] [ -o outfile ] dicfile...\n");
    exit(1);
}

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<translate>: call <trans>
------------------------------------------------------------------------------
*/

static void translate(dicfile, fp_out, fp_w)
    char *dicfile;
    FILE *fp_out, *fp_w;
{
    FILE *fp_in;

    fp_in = cha_fopen(dicfile, "r", 1);
    if(fp_out)
      fprintf(stderr, "%s\n", dicfile);
    trans(fp_in, fp_w);
    fclose(fp_in);
}

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<mainprcs>: main process (call <translate>)
------------------------------------------------------------------------------
*/

static void mainprcs(argv, fp_out, fp_w)
    char *argv[];
    FILE *fp_out, *fp_w;
{
    time_t t0, t1;
#ifdef _WIN32
    struct _finddata_t file;
    long hFile;
#endif

    time(&t0);

    if (fp_out)
      fprintf(stderr, "parsing dictionaries...\n");

    for (; *argv != NULL; argv++) {
#ifdef _WIN32
	hFile = _findfirst(*argv, &file);
	do {
	    translate(file.name, fp_out, fp_w);
	} while (!_findnext(hFile, &file));
	_findclose( hFile );
#else
	translate(*argv, fp_out, fp_w);
#endif
    }

    time(&t1);

    if (fp_out)
      fprintf(stderr, "processing time: %d sec\n", (int)(t1 - t0));
}

/*
------------------------------------------------------------------------------
	FUNCTION
	<main>: main routine
------------------------------------------------------------------------------
*/
int main(argc, argv)
    int argc;
    char *argv[];
{
    FILE *fp_out, *fp_w;
    int c;

    set_progpath(argv[0]);

    fp_out = stderr;
    fp_w = stdout;

    while ((c = cha_getopt(argv, "qo:", stderr)) != EOF) {
	switch (c) {
	  case 'q':
	    fp_out = NULL;
	    break;
	  case 'o':
	    fp_w = cha_fopen(*argv, "w", 1);
	    break;
	  case '?':
	    usage();
	}
    }
    argv += Cha_optind;

    if (argv[0] == NULL)
      usage();

    read_grammar(fp_out, 1, 2);
    read_katuyou(fp_out, 2);
    read_table(fp_out, 2);
    mainprcs(argv, fp_out, fp_w);

    return 0;
}

