#ifndef VERSION
#define VERSION "0.20?"
#endif
static char c1[] = "     display-dhammapada V" VERSION " \n";
static char c2[] = " (C) January 1997, 1998 by Ricardas Cepas <rch@pub.osf.lt>. \n";
static char c3[] = " Copying policy: Public Domain.\n";
static char c4[] = " No warranty. \n";
static char c5[] = " ANSI C. Tested with GCC 2.7.2.3 \n";

#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#define max_string_length 278
#define mark_length 4
#ifndef DPPATHNAME
#define DPPATHNAME "/usr/local/lib/display-dhammapada/dhammapada-english-transl.txt"
#endif
#ifndef DPPATHNAME2
#define DPPATHNAME2 "/usr/lib/display-dhammapada/dhammapada-english-transl.txt"
#endif

static const char dp_pathname1[] = DPPATHNAME;
static const char c6[] = "                                                                                  ";
static const char dp_pathname2[] = DPPATHNAME2;
static const char c7[] = "                                                                                  ";
static const char dp_pathname3[] = "dhammapada-english-transl.txt";
static const char c8[] = "                                                                                  ";
const char IO_err[] = "I/O error";
const char cannot_open[] = "    -- cannot open any of the files.";
const char too_long_verse[] = " file format error ?";
const char unexp_EOF[] = "unexpected end of file.";


const max_strings_in_verse = 20;

/*const long min_all_verses_size=50; */
static struct
  {
       char begin[mark_length], end[mark_length];
  }
marks[] =
  {
       {"1.","2"},{"2","4"},{"4","5"},{"5","6"},{"6","8"},
       {"8","10"},{"10","12"},{"12","14"},{"14","16"},{"16","18"},
       {"18","20"},{"2.","22"},{"22","24"},{"24","26"},{"26","28"},
       {"28","30"},{"30","32"},{"3.","33"},{"33","35"},{"35","36"},
       {"36","37"},{"37","39"},{"39","41"},{"41","43"},{"4.","45"},
       {"45","46"},{"46","47"},{"47","48"},{"48","49"},{"49","50"},{"50","52"},
       {"52","53"},{"53","54"},{"54","55"},{"55","56"},{"56","57"},
       {"57","59"},{"5.","60"},{"60","61"},{"61","62"},{"62","63"},
       {"63","65"},{"65","66"},{"66","68"},{"68","69"},{"69","70"},{"70","71"},
       {"71","72"},{"72","75"},{"6.","76"},{"76","77"},{"77","78"},
       {"78","79"},{"79","80"},{"80","81"},{"81","82"},{"82","83"},
       {"83","84"},{"84","86"},{"86","88"},{"88","89"},{"7.","90"},
       {"90","91"},{"91","92"},{"92","93"},{"93","94"},{"94","95"},
       {"95","96"},{"96","97"},{"97","98"},{"98","99"},{"8.","100"},
       {"100","101"},{"101","102"},{"102","103"},{"103","105"},{"105","106"},
       {"106","107"},{"107","108"},{"108","109"},{"109","110"},{"110","111"},
       {"111","112"},{"112","113"},{"113","114"},{"114","115"},{"9.","116"},
       {"116","118"},{"118","120"},{"120","122"},{"122","124"},{"124","125"},
       {"125","126"},{"126","128"},{"10.","130"},{"130","132"},{"132","133"},
       {"133","134"},{"134","135"},{"135","136"},{"136","140"},{"140","142"},
       {"142","143"},{"143","144"},{"144","145"},{"11.","146"},{"146","147"},
       {"147","148"},{"148","149"},{"149","150"},{"150","151"},{"151","152"},
       {"152","154"},{"154","155"},{"155","156"},{"12.","157"},{"157","158"},
       {"158","159"},{"159","160"},{"160","161"},{"161","162"},{"162","163"},
       {"163","164"},{"164","165"},{"165","166"},{"13.","167"},{"167","168"},
       {"168","169"},{"169","170"},{"170","171"},{"171","172"},{"172","173"},
       {"173","174"},{"174","175"},{"175","176"},{"176","177"},{"177","178"},{"14.","179"},
       {"179","180"},{"180","181"},{"181","182"},{"182","183"},{"183","184"},{"184","185"},
       {"185","187"},{"187","192"},{"192","193"},{"193","194"},{"194","196"},
       {"15.","197"},{"197","198"},{"198","199"},{"199","200"},{"200","201"},
       {"201","202"},{"202","204"},{"204","205"},{"205","207"},{"207","208"},
       {"16.","209"},{"209","211"},{"211","212"},{"212","213"},{"213","214"},
       {"214","215"},{"215","216"},{"216","217"},{"217","218"},{"218","220"},
       {"17.","221"},{"221","222"},{"222","223"},{"223","224"},{"224","225"},
       {"225","226"},{"226","227"},{"227","228"},{"228","230"},{"230","231"},
       {"231","232"},{"232","233"},{"233","234"},{"18.","236"},{"236","238"},
       {"238","239"},{"239","240"},{"240","241"},{"241","242"},{"242","243"},
       {"243","245"},{"245","248"},{"248","250"},{"250","251"},{"251","252"},
       {"252","253"},{"253","254"},{"254","255"},{"19.","257"},{"257","258"},
       {"258","259"},{"259","261"},{"261","263"},{"263","265"},{"265","267"},
       {"267","269"},{"269","270"},{"270","272"},{"20.","273"},{"273","274"},
       {"274","275"},{"275","276"},{"276","277"},{"277","278"},{"278","279"},
       {"279","280"},{"280","281"},{"281","282"},{"282","283"},{"283","284"},
       {"284","285"},{"285","286"},{"286","287"},{"287","289"},{"21.","290"},
       {"290","291"},{"291","293"},{"293","295"},{"295","296"},{"296","297"},
       {"297","298"},{"298","299"},{"299","300"},{"300","301"},{"301","302"},
       {"302","303"},{"303","304"},{"304","305"},{"22.","306"},{"306","307"},
       {"307","308"},{"308","309"},{"309","310"},{"310","311"},{"311","312"},
       {"312","313"},{"313","314"},{"314","315"},{"315","316"},{"316","317"},
       {"317","319"},{"23.","320"},{"320","321"},{"321","322"},{"322","323"},
       {"323","324"},{"324","325"},{"325","326"},{"326","327"},{"327","329"},{"329","331"},
       {"331","332"},{"332","333"},{"24.","334"},{"334","336"},{"336","337"},
       {"337","338"},{"338","339"},{"339","340"},{"340","341"},{"341","342"},
       {"342","343"},{"343","344"},{"344","346"},{"346","347"},
       {"347","348"},{"348","351"},{"351","352"},{"352","353"},{"353","354"},
       {"354","355"},{"355","356"},{"356","357"},{"357","358"},{"358","359"},
       {"25.","360"},{"360","361"},{"361","362"},{"362","363"},{"363","364"},
       {"364","365"},{"365","366"},{"366","367"},{"367","368"},{"368","369"},
       {"369","370"},{"370","371"},{"371","372"},{"372","373"},{"373","374"},{"374","376"},
       {"376","377"},{"377","378"},{"378","379"},{"379","380"},{"380","381"},{"381","382"},
       {"26.","383"},{"383","384"},{"384","385"},{"385","386"},{"386","387"},
       {"387","388"},{"388","389"},{"389","390"},{"390","391"},{"391","392"},
       {"392","393"},{"393","394"},{"394","395"},{"395","396"},{"396","397"},
       {"397","398"},{"398","399"},{"399","400"},{"400","401"},{"401","402"},
       {"402","403"},{"403","404"},{"404","405"},{"405","406"},{"406","407"},
       {"407","408"},{"408","409"},{"409","410"},{"410","411"},{"411","412"},
       {"412","413"},{"413","414"},{"414","415"},{"415","416"},{"416","417"},
       {"417","418"},{"418","419"},{"419","420"},{"420","421"},{"421","422"},
       {"422","423"}
  };

void
Error (const char *message)
{
     fprintf (stderr, "dp: %s \n", message);
     exit (1);
}

void
Find_begin_of_verses (FILE * dp)
{
     char s[max_string_length];

     rewind (dp);
     do
          if (fgets (s, max_string_length, dp) == NULL)
               if (feof (dp))
                    Error (unexp_EOF);
               else
                    Error (IO_err);
     while (strstr (s, "---------------------------------------------") == NULL);
     do
          if (fgets (s, max_string_length, dp) == NULL)
               if (feof (dp))
                    Error (unexp_EOF);
               else
                    Error (IO_err);
     while (strstr (s, "---------------------------------------------") == NULL);
}
void
Find_verse (FILE * dp, char *begin_mark)
{
     char s[max_string_length];

     do
          if (fgets (s, max_string_length, dp) == NULL)
               if (feof (dp))
                    Error (unexp_EOF);
               else
                    Error (IO_err);
     while (strstr (s, begin_mark) == NULL);
}

void
Help ()
{
     printf ("%s Displays a random verse \n", c1);
     printf ("from %s \nor from %s \nor from %s file. \n", dp_pathname1, dp_pathname2, dp_pathname3);
     printf (" Arguments: \n           <number>         specify number of verse(s) to display \n           all              display all file at once \n");
     printf (" Arguments for debugging only: \n           0x<hex_number>   specify internal index of verse(s) to display \n           0xall            display all file at once \n");
     printf ("%s%s%s", c2, c3, c4);
}

void
Print_verse (FILE * dp, char *end_mark)
{
     char s[max_string_length];
     int printed_strings_counter = 0;

     do
       {
            if (fgets (s, max_string_length, dp) == NULL)
                 if (feof (dp))
                      Error (unexp_EOF);
                 else
                      Error (IO_err);
            printf (" %s ", s);
            printed_strings_counter++;
            if (printed_strings_counter > max_strings_in_verse)
                 Error (too_long_verse);
       }
     while (strstr (s, end_mark) == NULL);
     printf ("\n");
}

void
Get_and_print_verse (FILE * dp, int index)
{
     Find_begin_of_verses (dp);
     if (index >= sizeof marks / sizeof marks[0])
          index = sizeof marks / sizeof marks[0] - 1;
     Find_verse (dp, marks[index].begin);
     Print_verse (dp, marks[index].end);
}

void
Get_and_print_verse_number_n (FILE * dp, int number)
{
  int index;

  for (index = 0; index < sizeof marks / sizeof marks[0] - 1; index++)
    if (number <= atoi (marks[index].end))
      break;
  Get_and_print_verse (dp, index);
}

int
Random_index ()
{
     int i, random_index;

     srand ((unsigned int) time (NULL));
/*      min=0, max=numb.of elem.-1+.999 */
     random_index = (int) ((double) (sizeof marks / sizeof marks[0]) * (i = rand ()) / (RAND_MAX + 1.0));
     return (random_index);
}

int
main (int argc, char *argv[], char *env[])
{
     FILE *dp;
     int index;
     char *stop_char_ptr;

     if ((dp = fopen (dp_pathname1, "rt")) == NULL)
        if ((dp = fopen (dp_pathname2, "rt")) == NULL)
          if ((dp = fopen (dp_pathname3, "rt")) == NULL)
            {
                 fprintf (stderr, " %s \n %s \n %s \n", dp_pathname1, dp_pathname2, dp_pathname3);
                 Error (cannot_open);
            }

     if (argc > 1)
       {
            if (strcmp (argv[1], "0xall") == 0)
                 for (index = 0; index < sizeof marks / sizeof marks[0]; index++)
                   {
                        printf ("0x%X \n", index);
                        Get_and_print_verse (dp, index);
                   }
	    else if (strcmp (argv[1], "all") == 0)
                 for (index = 0; index < sizeof marks / sizeof marks[0]; index++)
		      Get_and_print_verse (dp, index);
            else
	    {
	      errno = 0;
	      index = strtol (argv[1], &stop_char_ptr, 0);
	      if (errno != ERANGE && *stop_char_ptr == '\0' && argv[1][0] != '\0')
		if (argv[1][0] == '0' && (argv[1][1] == 'x' || argv[1][1] == 'X'))
		{
		    printf ("0x%X \n", index);
		    Get_and_print_verse (dp, index);
		}
		else
		{
		    Get_and_print_verse_number_n (dp, index);
		}
            else
                 Help ();
	    }
       }
     else
          Get_and_print_verse (dp, Random_index ());
     fclose (dp);
     exit (0);
}
