/*
 * Undo the UTF graphics of messages on 163.35 MHz
 *
 * It may help to know that maybe the data really is valid, at
 * least emwin got a matching checksum before we got here...
 *
 * Or, error free files came from the NWS ftp site...
 * http://iwin.nws.noaa.gov/pub/data/graphics/
 * ftp://iwin.nws.noaa.gov/g:\www\pub\data\graphics
 */
#define HOSED
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>
#include <ctype.h>
#include "utf.h"
#include "version.h"

int ps_utf_preamble(FILE *fp,char *title);
int ps_utf_trailer(FILE *fp);

int currX, currY;
FILE *psfp;

typedef struct {
  char filename[512];
  char *product;
  int filesize;
  unsigned char *data;
} UTFrecord;

int
UTFunstuff(UTFrecord *utf)
{
  int i;
  unsigned char *rp, *wp;

  /* UTF files have been stuffed 0203 -> 020 014 (and 020 -> 020 020). */
  wp = rp = utf->data; /* Start read and write pointers at 1st data item */
  for (i=0;i<utf->filesize;i++) {
    if (*rp == 0x10) {
      rp++; i++;
      switch (*rp) {
      case 0x10:
	*wp = 0x10; break;
      case 0x0C:
	*wp = 0x83; break;
      default:
	fprintf(stderr,"Error unstuffing UTF file.\n");
	return(1);
      }
    } else { /* No need to unstuff, but everything may get shifted. */
      *wp = *rp;
    }
    rp++; wp++;
  }
  while (wp<rp) {*wp=0; wp++;} /* Null out past end of unstuffed file */
  return(0);
}

int
UTFparse(UTFrecord *utf)
{
  unsigned char *up;  /* up: unsigned pointer */
  unsigned char *end;
  unsigned int gpd1cnt=0, dc2cnt=0, rv3cnt=0, av4cnt=0, ac5cnt=0,
    vec6cnt=0, cpc7cnt=0, oac8cnt=0, gdf31cnt=0, unkcnt=0;

  end = &(utf->data[utf->filesize]);
  up=utf->data;
  /* Pass over initial string, and its null termination */
  while(0==((*up)&0x80)) up++; 
  /* *up now has a high bit set - most likely *up == 0xc1 ... */
  while(up < end)
  switch(*up) {
  case 0: /* Done, normal completion */
    up++; /* maybe not return(0); */
    break;
  case 0xC1: /* Graphics Product Description */
    up = gpd1parse(up); gpd1cnt++;
    break;
  case 0xC2: /* Device Command */
    up = dc2parse(up); dc2cnt++;
    break;
  case 0xC3: /* Relative Vectors */
    up = rv3parse(up); rv3cnt++;
    break;
  case 0xC4: /* Absolute Vectors */
    up = av4parse(up); av4cnt++;
    break;
  case 0xC5: /* Alphanumeric (ASCII) Characters */
    up = ac5parse(up); ac5cnt++;
    break;
  case 0xC6: /* Variable Exception Vector (VEC) */
    up = vec6parse(up); vec6cnt++;
    break;
  case 0xC7: /* Compact Pen Command (CPC) Vectors */
    up = cpc7parse(up); cpc7cnt++;
    break;
  case 0xC8: /* Offset Alphanumeric Characters */
    up = oac8parse(up); oac8cnt++;
    break;
  case 0xDf: /* Gridded Data Field */
    up = gdf31parse(up); gdf31cnt++;
    break;
  default: /* Done, error */
    printf("Unknown type: %X\n",*up); unkcnt++;
    up++; /* return(*up); */
    break;
  }

  printf("%u Graphics Product Description\n",gpd1cnt);
  printf("%u Device Command\n",dc2cnt);
  printf("%u Relative Vectors\n",rv3cnt);
  printf("%u Absolute Vectors\n",av4cnt);
  printf("%u Alphanumeric Characters\n",ac5cnt);
  printf("%u Variable Exception Vector\n",vec6cnt);
  printf("%u Compact Pen Command\n",cpc7cnt);
  printf("%u Offset Alphanumeric Characters\n",oac8cnt);
  printf("%u Gridded Data Field\n",gdf31cnt);
  printf("%u Unknown\n",unkcnt);
  return(0); /* Can't get here */
}

/*
 * For now, give it a complete valid file. Maybe later it can put
 * together its own valid file from the pieces emwin delivers.
 */
int
main(int argc,char *argv[])
{
  FILE *fp;
  struct stat stats;
  UTFrecord *utf;
  unsigned char *cp;
  int i;

  if (argc<2) {
    printf("Try: %s GPHfile\n\twhere GPHfile is a valid UTF file\n",
	   argv[0]);
    return(1);
  }
  utf = (UTFrecord *) malloc(sizeof(UTFrecord));

  if (argc>2) psfp = fopen(argv[2],"w");
  else psfp = fopen("utfout.ps","w");

  sprintf(utf->filename,"%s",argv[1]);
  fflush(stdout);
  stat(argv[1],&stats);
  utf->filesize = stats.st_size;
  utf->data = (unsigned char *)malloc(utf->filesize);
  fp = fopen(argv[1],"r");
  fread(utf->data,utf->filesize,1,fp);
  fclose(fp);
  if (UTFunstuff(utf)) return(1);
#ifdef NAIVE
  utf->product=(char *)utf->data; /* Seems the first bit is null terminated. */
#else
  /* _Sometimes_ it's null terminated, sometimes we run right into the
     first product. This will work correctly for more types of files. */
  utf->product = (char *)malloc(64);
  cp=(unsigned char *)utf->data;
  for(i=0;i<63;i++) {
    if (isprint(*cp)) utf->product[i] = *cp;
    else utf->product[i] = 0; /* null terminate */
    cp++;
    if (!(utf->product)) break;
  }
#endif
  ps_utf_preamble(psfp,utf->product);
  /* fprintf(psfp,"100 100 moveto\n(%s) show\n",argv[1]); */

  fprintf(psfp,"%%%% File %s contaning product %s\n",utf->filename,utf->product);
  UTFparse(utf);
  printf("Processed a %d byte file of %s.\n",utf->filesize,utf->product);

  free(utf);
  ps_utf_trailer(psfp);
  fclose(psfp);
  return(0);
}

unsigned char *
gpd1parse(unsigned char *up)
{
  unsigned int D,M,Y,h,m;
  ProductDefinition *pd;

  fprintf(psfp,"%%%% UTF Graphics Product Definition:\n");

  pd = (ProductDefinition *)up;
  fprintf(psfp,"%%%% Background Map PI: %u\n",pd->PI);
  fprintf(psfp,"%%%% Map Scale GS: %u\n",ntohs(pd->GS));
  fprintf(psfp,"%%%% IMAX: %u\n",ntohs(pd->IMAX));
  fprintf(psfp,"%%%% JMAX: %u\n",ntohs(pd->JMAX));
#ifdef HOSED /* why does this code make core files? */
  D = pd->DAY;
  M = pd->MONTH;
  Y = pd->YEAR; /* Not year 2000 complient!! */
#else
  pd->DMY = htons(pd->DMY);
  D = ((pd->DMY)&0xF800)>>11;
  M = ((pd->DMY)&0x0780)>>7;
  Y = ((pd->DMY)&0x007F);
#endif
  h = (ntohs(pd->TIME)>>4)/60;
  m = (ntohs(pd->TIME)>>4)%60;
  fprintf(psfp,"%%%% %u/%u/%u  %u:%02u\n",M,D,Y,h,m);
  printf("Product dated %u/%u/%u  %u:%02u\n",M,D,Y,h,m);
  printf("PDC=%d, PI=%d\n",pd->TIME&0x000F,*(++up)); ++up;
  ++up; ++up; /* Word 2 */
  ++up; ++up;
  ++up; ++up;
  ++up; ++up;
  ++up; ++up; /* Word 6 */
  return(up);
}

unsigned char *
dc2parse(unsigned char *up)
{
  int device, i, wordcount;
  unsigned short *wp; /* wp: word pointer */

  wp = (unsigned short *)up;
  device = (*wp)&0x003F;
  wp++; up++; up++;
  wordcount = *wp;
  printf("Device %d Control (%d words):\n",device,wordcount);
  for (i=0;i<wordcount;i++) {
    wp++; up++; up++;
    /* printf("%6d: %04X\n",i,*wp); */
  }
  return(up);
}

unsigned char *
rv3parse(unsigned char *up)
{
  int X,Y,draw,i,wordcount;
  unsigned short *wp; /* wp: word pointer */
  RelativeVectors *vp;
  unsigned char flags;

  fprintf(psfp,"%%%% Relative Vectors:\n");
  vp = (RelativeVectors *) up;
  up++; flags=*up; up++;
  up++; up++;
  up++; up++;
  if (!(flags&0x20))
    fprintf(psfp,"%%%% ZT:%u, ZF:%u\n",(flags&0x18)>>3,flags&0x07);
  /* if (*wp==0x8000) *wp=82; Huh? */
  wordcount = ntohs(vp->nwords);
  /* printf("%d words of data.\n",wordcount); */
  up++; up++;
  /* printf("Starting at (%u,%u)\n",ntohs(vp->STARTI),ntohs(vp->STARTJ)); */
  moveto(ntohs(vp->STARTI),ntohs(vp->STARTJ));
  wp = &(vp->data);
  for(i=0;i<wordcount;i++) {
    *wp = ntohs(*wp);
    if (*wp & 0x8000) {
      if (*wp & 0x0080) draw=0; else draw=1;
      X=(*wp&0x3F00)>>8;
      if (*wp & 0x4000) X = 0xFFFFFFC0|X;
      Y=*wp&0x003F;
      if (*wp & 0x0040) Y = 0xFFFFFFC0|Y;
      if (draw) drawrel(X,Y); else moverel(X,Y);
    } else {
      if (ntohs(wp[1])&0x2000) draw=0; else draw=1;
      X=*wp&0x0FFF;
      if (*wp & 0x1000) X = 0xFFFFF000|X;
      wp++; up++; up++; i++;
      *wp = ntohs(*wp);
      Y=*wp&0x0FFF;
      if (*wp & 0x1000) Y = 0xFFFFF000|Y;
      if (draw) drawrel(X,Y); else moverel(X,Y);
    }
    wp++; up++; up++;
  }
  return(up);
}

unsigned char *
av4parse(unsigned char *up)
{
  int i, wordcount, X, Y;
  unsigned short *wp; /* wp: word pointer */

  fprintf(psfp,"%%%% Absolute Vectors\n");
  wp = (unsigned short *)up;
  fprintf(psfp,"%%%% ZT = %d\n",(*wp&0x0018)>>2);
  fprintf(psfp,"%%%% ZF = %d\n",*wp&0x0007);
  wp++;
  X = *wp++;
  Y = *wp++;
  moveto(X,Y);
  wordcount = *wp; wp++;
  for (i=0;i<wordcount/2;i++) {
    X = *wp++;
    Y = *wp++;
    if (Y&0x8000) {
      moveto(X&0x7FFF,Y&0x7FFF);
    } else {
      drawto(X&0x7FFF,Y&0x7FFF);
    }
  }
  return(up);
}

unsigned char *
ac5parse(unsigned char *up)
{
  int X, Y;

  up++;
  fprintf(psfp,"%%%% Alphanumeric Characters %02x\n",*up);
  if (!(0x80&(*up))) {
    up++;
    X = *up&0x3F; up++;
    X = X*256 + *up; up++;
    Y = *up; up++;
    Y = Y*256 + *up; up++;
    fprintf(psfp,"%d %d moveto\n",X,Y);
  } else {
    fprintf(psfp,"%%%% Non-graphic message text:\n");
    up++;
  }
  fprintf(psfp,"( ");
  while (3 != (((*up)&0xC0)>>6)) {
    fprintf(psfp,"%c",*up); up++;
  }
  fprintf(psfp," ) show\n");
  return(up);
}

unsigned char *
vec6parse(unsigned char *up)
{
  int i, X, Y, VL, NBITS;
  unsigned short *wp; /* wp: word pointer */

  up++;
  printf("Variable Exception Vectors (VEV) %02X\n",*up);
  fprintf(psfp,"%%%% Variable Exception Vectors (VEV) %02X\n",*up);
  up++;
  wp = (unsigned short *)up;
  X = (ntohs(*wp))&0x3FFF; VL = ((ntohs(*wp))&0xC000)>>14;
  wp++; up++; up++;
  Y = ntohs(*wp);
  wp++; up++; up++;
  NBITS = ntohs(*wp);
  printf("VL=%d, NBITS=%d\n",VL,NBITS);
  fprintf(psfp,"%%%% VL=%d, NBITS=%d\n",VL,NBITS);
  wp++; up++; up++;
  for (i=0;i<NBITS/8; i++) up++;
  if (NBITS%8) up++;
  return(up);
}

unsigned char *
cpc7parse(unsigned char *up)
{
  int X, Y, NVECTORS;
  unsigned short *wp; /* wp: word pointer */

  up++;
  printf("Compact Pen Command (CPC) vectors %02X\n",*up);
  fprintf(psfp,"%%%% Compact Pen Command (CPC) vectors %02X\n",*up);
  up++;
  wp = (unsigned short *)up;
  X = *wp;
  wp++; up++; up++;
  Y = *wp;
  wp++; up++; up++;
  NVECTORS = *wp;
  printf("At %d,%d NVECTORS=%d\n",X,Y,NVECTORS);
  fprintf(psfp,"%%%% At %d,%d NVECTORS=%d\n",X,Y,NVECTORS);
  wp++; up++; up++;
  return(up);
}

unsigned char *
oac8parse(unsigned char *up)
{
  int X, Y;
  unsigned char flags;

  fprintf(psfp,"%%%% Offset alphanumeric characters\n");
  up++; flags=*up;
  if (!(flags&0x20))
    fprintf(psfp,"%%%% ZT:%u, ZF:%u\n",(flags&0x18)>>3,flags&0x07);
  up++;
  X = *up&0x3F; up++;
  X = X*256 + *up; up++;
  Y = *up; up++;
  Y = Y*256 + *up; up++;
  if (!(*up&0x80))
    X = X + *up;
  else
    X = X - (*up&0x7F);
  up++;
  if (!(*up&0x80))
    Y = Y + *up;
  else
    Y = Y - (*up&0x7F);
  up++;
  fprintf(psfp,"%d %d moveto\n",X,Y);
  fprintf(psfp,"( ");
  while (3 != (((*up)&0xC0)>>6)) {
    fprintf(psfp,"%c",*up); up++;
  }
  fprintf(psfp," ) show\n");
  return(up);
}

unsigned char *
gdf31parse(unsigned char *up)
{
  printf("Gridded Data Format\n");
  up++;
  return(up);
}

int moveto(int x, int y)
{
  fprintf(psfp,"%d %d moveto\n",x,y);
  currX=x; currY=y;
  return(0);
}
int drawto(int x, int y)
{
  fprintf(psfp,"%d %d lineto\n",x,y);
  currX=x; currY=y;
  return(0);
}
int moverel(int x, int y)
{
  currX+=x; currY+=y;
  fprintf(psfp,"%d %d moveto\n",currX,currY);
  return(0);
}
int drawrel(int x, int y)
{
  fprintf(psfp,"%d %d moveto\n",currX,currY);
  currX+=x; currY+=y;
  fprintf(psfp,"%d %d lineto\n",currX,currY);
  return(0);
}

int
ps_utf_preamble(FILE *fp,char *title)
{
  fprintf(fp,"%%!PS-Adobe-2.0 EPSF-1.2\n");
  fprintf(fp,"%%%%Creator: A. Maitland Bottoms\n");
  fprintf(fp,"%%%%Title: %s\n",title);
  fprintf(fp,"%%%%CreationDate: Tue Aug 18 21:51:14 1998\n");
  fprintf(fp,"%%%%Pages: 1\n");
  fprintf(fp,"%%%%PageOrder: Ascend\n");
  fprintf(fp,"%%%%Orientation: Landscape\n");
  fprintf(fp,"%%%%DocumentPaperSizes: Letter\n");
  fprintf(fp,"%%%%BoundingBox: 0 0 612 792\n");
  fprintf(fp,"%%%%DocumentFonts: Times-Roman Times-Bold Times-Italic\n");
  fprintf(fp,"%%%%EndComments\n");
  fprintf(fp,"%%%%EndProlog\n");
  fprintf(fp,"/Times-Roman findfont 21.00 scalefont setfont\n");
  fprintf(fp,"90 rotate 18 -576 translate\n");
  fprintf(fp,"10 /linewidth\n");
  fprintf(fp,"0.33 0.33 scale\n");
  return(0);
}

int
ps_utf_trailer(FILE *fp)
{
  fprintf(fp,"stroke\n");
  fprintf(fp,"%%%%PageTrailer\n");
  fprintf(fp,"showpage\n");
  fprintf(fp,"%%%%Trailer\n");
  fprintf(fp,"%%%%EOF\n");
  return(0);
}
