/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_BOARD_H
#define GATOS_BOARD_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_BOARD_C
#define WHERE       
#else
#define WHERE	extern
#endif

#define TDA8425(R,V)	\
	{ i2c_writereg8(gatos.tda8425.addr,(R),(V)) ; tda8425reg[R] = V ; }
#define TDA9850(R,V)	i2c_writereg8(gatos.tda9850.addr,(R),(V))
#define TDA9851(R,V)	i2c_writereg8(gatos.tda9851.addr,(R),(V))

/* Board function declarations */

int	board_init(void) ;
int	board_setmux(void) ;
int	board_setvol(int) ;
int	board_setmute(void) ;
int	board_setstereo(void) ;
int	board_setsap(void) ;
int	board_hasvol(void) ;
int	board_hasstereo(void) ;
int	board_hassap(void) ;
int	board_isstereo(void) ;
void	board_dumpregs(void) ;

#ifdef GATOS_BOARD_C
static u8	board_identify(u8*, u8*) ;
static int	board_setbyte(void) ;
static int	board_setaudio(void) ;
#if 0 /* NIY */
static int	MSP3410(u8, u16, u16) ;
#endif
static u16	MSP3410get(u8, u16) ;
#endif

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
