/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_SOUND_H
#define GATOS_SOUND_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_SOUND_C
#define WHERE       
#else
#define WHERE	extern
#endif

#include <stdlib.h>
#ifdef __linux__
#include <sys/soundcard.h>
#else
#include <machine/soundcard.h>
#endif

#ifdef GATOS_SOUND_C
WHERE char *mixer_names[SOUND_MIXER_NRDEVICES] = SOUND_DEVICE_NAMES ;
#else
WHERE char *mixer_names[SOUND_MIXER_NRDEVICES] ;
#endif

/* Sound function declarations */

int	sound_init(void) ;
int	sound_restore(void) ;
int	sound_setvol(int) ;
int	sound_setmixer(int) ;
int	sound_nummixers() ;
char*	sound_mixername(int) ;
char**	sound_mixernames() ;

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
