#ifndef __XUTILS_H__
#define __XUTILS_H__

#include "gatos.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct{
	long black_col;
	long white_col;
	long yellow_col;
	long magenta_col;
	long red_col;
	long green_col;
	long blue_col;
	long cyan_col;
	long bg_col;
	}PALETTE;

void createProtoImage(Display *display,Drawable d);

void fillPalette(Display *d,Drawable dw, GC gc, PALETTE *p); 
int get_actual_depth(void);
void reset_xutils_stats(void);
void print_xutils_stats(void);

#define NORMAL_ATTR 	0
#define ITALIC_ATTR 	1
#define UNDERLINE_ATTR 	2

/* the following returns an image of the string 
   special codes:
      \i   change to italic
      \f   change to normal font
      \y   print in yellow
      \r   print in red
      \b   print in blue
      \g   print in green
      \m   print in magenta
      \\   print \
    Note: it currently does not understand \n  
 */
XImage *printString(char *string,char *font,long height,PALETTE *pal);
void DGADrawRectangle(u8 *frame,int depth, int ysize,int x,int y,int width,int height,
			long color);
void DGAPutImage(u8 *frame,long ysize,int x,int y,XImage *im);
XImage * XScaleImage(XImage *im,double ratio,long black,double slant);
void XFreeImage(XImage *im);
XImage *charToImage(char c,long fg_color, long bg_color);
XImage *getScaledChar(char c,long height, long fg_color,long bg_color, u8 attribute);
XImage *getCCChar(char c, long height, int attr,PALETTE *pal);

#ifdef __cplusplus
}
#endif


#endif
