.TH TRIANGULATE l "1 November 1999"
.SH NAME
triangulate \- Perform optimal Delauney triangulation and gridding
.SH SYNOPSIS
\fBtriangulate\fP \fIinfiles\fP [ \fB\-Dx|y\fP ] [ \fB\-E\fP\fIempty\fP ] [ \fB\-G\fP\fIgrdfile\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-I\fP\fIx_inc\fP[\fBm|c\fP][/\fIy_inc\fP[\fBm|c\fP]] ] [ \fB\-J\fP\fIparameters\fP ] [ \fB\-M\fP[\fIflag\fP] ] 
[ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] ] [ \fB\-V\fP ] [ \fB\-Z\fP ] [ \fB\-:\fP ] 
[ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBtriangulate\fP reads one or more ASCII [or binary] files (or standard input) containing x,y[,z] and
performs Delauney triangulation, i.e., it find how the points should be connected to give
the most equilateral triangulation possible.  If a map projection is chosen then it is applied before
the triangulation is calculated.  By default, the output is triplets of point id numbers
that make up each triangle and is written to standard output.
The id numbers refer to the points position in the input file.
As an option, you may choose to create a multiple segment file that can be piped through
\fBpsxy\fP to draw the triangulation network.  If \fB\-G \-I\fP are set a grid will be calculated based
on the surface defined by the planar triangles.  The actual algorithm used
in the triangulations is either that of Watson [1982] [Default] or Shewchuck [1996] (if installed).
This choice is made during the GMT installation.
.TP
\fIinfiles\fP
Data files with the point coordinates in ASCII (or binary; see \fB\-b\fP).  If no files are given the standard input is read.
.SH OPTIONS
.TP
.B \-D
Take either the \fIx\fP- or \fIy\fP-derivatives of surface represented
by the planar facets (only used when \fB\-G\fP is set).
.TP
.B \-E
Set the value assigned to empty nodes when \fB\-G\fP is set [NaN].
.TP
.B \-G
Use triangulation to grid the data onto an even grid (specified with \fB\-I, \-R\fP).  Append
the name of the output grid file.  The interpolation is performed in the
original coordinates, so if your triangles are close to the poles you are
better off projecting all data to a local coordinate system before using
triangulate (this is true of all gridding routines).
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] sets the grid  size for optional grid output (see \fB\-G\fP).
Append \fBm\fP to indicate minutes or \fBc\fP to indicate seconds.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optionally offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-M
Output triangulation network as multiple line segments separated by a record whose first
character is \fIflag\fP [>].  To plot, use \fBpsxy\fP with the \fB\-M\fP option (see Examples).
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-Z
Controls whether binary data file has two or three columns [2].  Ignored if \fB\-b\fP
is not set.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 2 input columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is double].
Node ids are stored as binary 4-byte integer triplets.  \fB\-bo\fP is ignored if \fB\-M\fP is selected.
.SH EXAMPLES
To triangulate the points in the file samples.xyz, store the triangle information in a binary file, and
make a grid for the given area and spacing, try
.br
.sp
triangulate samples.xyz \fB\-bo\fP \fB\-R\fP0/30/0/30 \fB\-I\fP2 \fB\-G\fPsurf.grd > samples.ijk
.br
.sp
To draw the optimal Delauney triangulation network based on the same file using a
15-cm-wide Mercator map, try
.br
.sp
triangulate samples.xyz \fB\-M \-R\fP-100/-90/30/34 \fB\-JM\fP15\fBc\fP | psxy \fB\-M \-R\fP-100/-90/30/34 \fB\-JM\fP15\fBc\fP
\fB\-W\fP0.5\fBp\fP \fB\-B\fP1 > network.ps
.SH "SEE ALSO"
.IR gmt (l),
.IR pscontour (l)
.SH REFERENCES
Watson, D. F., 1982, Acord: Automatic contouring of raw data, \fIComp. & Geosci., 8\fP, 97\-101.
.br
Shewchuck, J. R., 1996, Triangle: Engineering a 2D Quality Mesh Generator
and Delaunay Triangulator, First Workshop on Applied Computational Geometry
(Philadelphia, PA), 124-133, ACM, May 1996.
.br
www.cs.cmu.edu/~quake/triangle.html
