=for foobar
   Copyright (C) 1999 Kyle R. Burton, All Rights Reserved
   mortis@voicenet.com
   http://www.bgw.org
   http://www.voicenet.com/~mortis

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

=cut

=head1 NAME

create_table.pl

=head2 DESCRIPTION

This script creates the file table_data.cc from the file table.txt

=cut

################################################################################
use strict;
use vars qw( $opt_l );
use Getopt::Std;

#my $optstr = "l:";
#getopts($optstr);
#unless( $opt_l ) {
#  die "Error, you must specify a language with -l (en, es, or fr)\n";
#}
#my $lang = $opt_l;

my $file = shift;
unless($file) {
  die "Error, you must specify a file.\n";
}

$file =~ /^([^\.]+)\.([^\.]+)\.([^\.]+)$/;
my $lang = $2;

unless( $lang ) {
  die "Error, could not determine language from file name: $file\n";
}

my $func = "init_table_" . $lang;
my $obj  = "table_" . $lang;

print <<"ENDOFTABLE";
#include <gtk/gtk.h>

#include <gperiodic.h>

extern table_entry *$obj;
extern int table_size;

int $func( void )
{
  delete [] $obj;
  $obj = new table_entry[table_size];

ENDOFTABLE

open FILE, "<$file" or die "Error opening file: $file  $!\n";
my $count = 0;
while(<FILE>) {
  chomp;               # remove the trailing newline
  s/#.*$//g;           # strip any comments
  s/^\s+//g;           # remove leading whitespace
  s/\s+$//g;           # remove trailing whitespace
  next unless length;  # skip blank lines
  my @elms = split /,/;   # break into an array by ','

	# produce the C++ code according to the data given...
	my $i = 0;
  print "  ",$obj,"[", $count, "].name    = dupstr(\"", $elms[$i++], "\");\n";
  print "  ",$obj,"[", $count, "].symbol  = dupstr(\"", $elms[$i++], "\");\n";
  print "  ",$obj,"[", $count, "].number  = dupstr(\"", $elms[$i++], "\");\n";
  print "  ",$obj,"[", $count, "].weight  = dupstr(\"", $elms[$i++], "\");\n";
  print "  ",$obj,"[", $count, "].melting = dupstr(\"", $elms[$i++], "\");\n";
  print "  ",$obj,"[", $count, "].boiling = dupstr(\"", $elms[$i++], "\");\n";
  print "  ",$obj,"[", $count, "].pauling = dupstr(\"", $elms[$i++], "\");\n";
  print "  ",$obj,"[", $count, "].x       = ", $elms[$i++], ";\n";
  print "  ",$obj,"[", $count, "].y       = ", $elms[$i++], ";\n";
  print "\n";

  ++$count;
}

print <<"ENDOFTABLE";
  return 1;
}

ENDOFTABLE

close FILE;
