/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "gstalker.h"

/*************************************************************************************/
void
ei_ma_spinner_changed()
{
  gint tint;
  extern struct record config;
  extern GtkWidget *ei_ma_spinner;
  
  
  tint = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(ei_ma_spinner));
  config.moving_value = tint;
  
  if (config.moving_status)
  {
  	create_ma_array(config.moving_type);
  	draw();
  }
}
/*************************************************************************************/
void
ei_ma2_spinner_changed()
{
  gint tint;
  extern struct record config;
  extern GtkWidget *ei_ma2_spinner;
  
  
  tint = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(ei_ma2_spinner));
  config.moving2_value = tint;
  
  if (config.moving2_status)
  {
  	create_ma2_array(config.moving2_type);
  	draw();
  }
}
/*************************************************************************************/
void
ei_ma3_spinner_changed()
{
  gint tint;
  extern struct record config;
  extern GtkWidget *ei_ma3_spinner;
  
  
  tint = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(ei_ma3_spinner));
  config.moving3_value = tint;
  
  if (config.moving3_status)
  {
  	create_ma3_array(config.moving3_type);
  	draw();
  }
}
/*************************************************************************************/
void
ei_ma_combo_changed()
{
  gchar *tstringp;
  extern struct record config;
  extern GtkWidget *ei_ma_combo;
  extern gchar *label_simple, *label_weighted;
  
  
  tstringp = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ei_ma_combo)->entry));
  if (strstr(tstringp, label_simple))
  	config.moving_type = 1;
  else
  {
  	if (strstr(tstringp, label_weighted))
  		config.moving_type = 2;
  	else
  		config.moving_type = 3;
  }
  create_ma_array(config.moving_type);
  if (config.moving_status)
  	draw();
}
/*************************************************************************************/
void
ei_ma2_combo_changed()
{
  gchar *tstringp;
  extern struct record config;
  extern GtkWidget *ei_ma2_combo;
  extern gchar *label_simple, *label_weighted;
  
  
  tstringp = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ei_ma2_combo)->entry));
  if (strstr(tstringp, label_simple))
  	config.moving2_type = 1;
  else
  {
  	if (strstr(tstringp, label_weighted))
  		config.moving2_type = 2;
  	else
  		config.moving2_type = 3;
  }
  create_ma2_array(config.moving2_type);
  if (config.moving2_status)
  	draw();
}
/*************************************************************************************/
void
ei_ma3_combo_changed()
{
  gchar *tstringp;
  extern struct record config;
  extern GtkWidget *ei_ma3_combo;
  extern gchar *label_simple, *label_weighted;
  
  
  tstringp = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ei_ma3_combo)->entry));
  if (strstr(tstringp, label_simple))
  	config.moving3_type = 1;
  else
  {
  	if (strstr(tstringp, label_weighted))
  		config.moving3_type = 2;
  	else
  		config.moving3_type = 3;
  }
  create_ma3_array(config.moving3_type);
  if (config.moving3_status)
  	draw();
}
/*************************************************************************************/
void
ei_ma_checked()
{
  extern struct record config;
  
  if (config.moving_status)
  	config.moving_status = 0;
  else
  {
  	config.moving_status = 1;
  	create_ma_array(config.moving_type);
  }
  draw();
  if (config.edit_alerts_window_open)
  	update_alerts_window ();
}
/*************************************************************************************/
void
ei_ma2_checked()
{
  extern struct record config;
  
  if (config.moving2_status)
  	config.moving2_status = 0;
  else
  {
  	config.moving2_status = 1;
  	create_ma2_array(config.moving2_type);
  }
  draw();
  if (config.edit_alerts_window_open)
  	update_alerts_window ();
}
/*************************************************************************************/
void
ei_ma3_checked()
{
  extern struct record config;
  
  if (config.moving3_status)
  	config.moving3_status = 0;
  else
  {
  	config.moving3_status = 1;
  	create_ma3_array(config.moving3_type);
  }
  draw();
  if (config.edit_alerts_window_open)
  	update_alerts_window ();
}
/***********************************************************************************/
void 
update_indicator_window()
{
  GString *tstring;
  extern struct record config;
  extern GtkWidget *ei_ma_check, *ei_ma2_check, *ei_ma3_check, *ei_ma_combo, *ei_ma2_combo;
  extern GtkWidget *ei_ma3_combo, *ei_ma_spinner, *ei_ma2_spinner, *ei_ma3_spinner;
  extern GtkWidget *edit_indicator_window;
  extern GString *current_symbol, *current_name;
  extern gchar *label_simple, *label_weighted, *label_exponential, *label_edit_indicators;


  tstring = g_string_new(NULL);
  
  if (config.moving_status)
	  	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(ei_ma_check), TRUE);
  if (config.moving2_status)
	  	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(ei_ma2_check), TRUE);
  if (config.moving3_status)
	  	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(ei_ma3_check), TRUE);
	  	
  if (config.moving_type == 1)
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ei_ma_combo)->entry), label_simple);
  if (config.moving_type == 2)
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ei_ma_combo)->entry), label_weighted);
  if (config.moving_type == 3)
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ei_ma_combo)->entry), label_exponential);
  if (config.moving2_type == 1)
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ei_ma2_combo)->entry), label_simple);
  if (config.moving2_type == 2)
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ei_ma2_combo)->entry), label_weighted);
  if (config.moving2_type == 3)
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ei_ma2_combo)->entry), label_exponential);
  if (config.moving3_type == 1)
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ei_ma3_combo)->entry), label_simple);
  if (config.moving3_type == 2)
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ei_ma3_combo)->entry), label_weighted);
  if (config.moving3_type == 3)
	gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ei_ma3_combo)->entry), label_exponential);
	
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(ei_ma_spinner),
	  				 (gfloat) config.moving_value);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(ei_ma2_spinner),
	  				 (gfloat) config.moving2_value);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(ei_ma3_spinner),
	  				 (gfloat) config.moving3_value);

  g_string_sprintf (tstring, "%s - %s (%s)", label_edit_indicators, current_name->str,
			current_symbol->str);
  gtk_window_set_title (GTK_WINDOW (edit_indicator_window), tstring->str);
  
  g_string_free(tstring, TRUE);
}
/*********************************************************************************/
void 
exit_edit_indicator_window ()
{
  extern GtkWidget *edit_indicator_window;
  extern struct record config;


  gtk_widget_destroy (edit_indicator_window);
  config.edit_indicators_window_open = 0;
}
/******************************************************************************************/
void 
edit_indicators ()
{
  GtkAdjustment *adj, *adj2, *adj3;
  GString *tstring;
  GtkWidget *vbox, *vbox2, *hbox, *hbox2, *hbox3, *hbox4, *close_button, *frame;
  extern GtkWidget *ei_ma_check, *ei_ma_combo, *ei_ma_spinner, *ei_ma2_check;
  extern GtkWidget *ei_ma2_combo, *ei_ma2_spinner, *ei_ma3_check, *ei_ma3_combo, *ei_ma3_spinner;
  extern GtkWidget *edit_indicator_window;
  extern gint chartflag;
  extern struct record config;
  extern GList *moving_type_list;
  extern GString *current_symbol, *current_name;
  extern gchar *label_edit_indicators, *label_indicators, *label_close, *label_ma, *label_ma2;
  extern gchar *label_ma3;



  if (chartflag != 1)
      return;
      
  tstring = g_string_new(NULL);
      
  if (config.edit_indicators_window_open)
	{
	  update_indicator_window ();
	  return;
	}
      else
	{
	  edit_indicator_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	  gtk_signal_connect (GTK_OBJECT (edit_indicator_window), "destroy",
			GTK_SIGNAL_FUNC (exit_edit_indicator_window), NULL);
	  gtk_container_border_width (GTK_CONTAINER (edit_indicator_window), 0);
	  gtk_window_position (GTK_WINDOW (edit_indicator_window), GTK_WIN_POS_CENTER);
	  gtk_widget_set_usize (GTK_WIDGET (edit_indicator_window), 0, 0);

	  g_string_sprintf (tstring, "%s - %s (%s)", label_edit_indicators, current_name->str,
	  				current_symbol->str);
	  gtk_window_set_title (GTK_WINDOW (edit_indicator_window), tstring->str);

	  hbox = gtk_hbox_new (FALSE, 10);
	  gtk_container_add (GTK_CONTAINER (edit_indicator_window), hbox);
	  gtk_container_border_width (GTK_CONTAINER (hbox), 10);
	  gtk_widget_show (hbox);
	  
	  frame = gtk_frame_new (label_indicators);
  	  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, TRUE, 0);
  	  gtk_container_border_width (GTK_CONTAINER (frame), 0);
  	  gtk_widget_show (frame);
  	  
  	  vbox2 = gtk_vbox_new (FALSE, 5);
  	  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  	  gtk_container_border_width (GTK_CONTAINER (vbox2), 5);
	  gtk_widget_show (vbox2);

	  vbox = gtk_vbutton_box_new ();
	  gtk_vbutton_box_set_spacing_default (5);
	  gtk_vbutton_box_set_layout_default (GTK_BUTTONBOX_START);
	  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
	  gtk_widget_show (vbox);
	  
	  close_button = gtk_button_new_with_label (label_close);
	  gtk_box_pack_start (GTK_BOX (vbox), close_button, FALSE, TRUE, 0);
	  gtk_signal_connect (GTK_OBJECT (close_button), "clicked",
			   GTK_SIGNAL_FUNC (exit_edit_indicator_window), NULL);
	  gtk_widget_show (close_button);

	  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 1.0, (gfloat) G_MAXINT,
	  										  1.0, 5.0, 0.0);
	  adj2 = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 1.0, (gfloat) G_MAXINT,
	  										  1.0, 5.0, 0.0);
	  adj3 = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 1.0, (gfloat) G_MAXINT,
	  										  1.0, 5.0, 0.0);
	  
	  hbox2 = gtk_hbox_new (FALSE, 10);
  	  gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, TRUE, 0);
	  gtk_widget_show (hbox2);
	  
	  ei_ma_check = gtk_check_button_new_with_label (label_ma);
	  gtk_box_pack_start (GTK_BOX (hbox2), ei_ma_check, FALSE, TRUE, 0);
	  gtk_widget_set_usize (GTK_WIDGET (ei_ma_check), 65, 0);
	  gtk_widget_show(ei_ma_check);
	  
	  ei_ma_combo = gtk_combo_new ();
      	  gtk_combo_set_popdown_strings (GTK_COMBO (ei_ma_combo), moving_type_list);
      	  gtk_box_pack_start (GTK_BOX (hbox2), ei_ma_combo, FALSE, TRUE, 0);
      	  gtk_widget_show (ei_ma_combo);
	  
	  ei_ma_spinner = gtk_spin_button_new(adj ,0, 0);
	  gtk_box_pack_start (GTK_BOX (hbox2), ei_ma_spinner, FALSE, TRUE, 0);
	  gtk_widget_set_usize (GTK_WIDGET (ei_ma_spinner), 50, 0);
	  gtk_widget_show(ei_ma_spinner);
	  
	  hbox3 = gtk_hbox_new (FALSE, 10);
  	  gtk_box_pack_start (GTK_BOX (vbox2), hbox3, FALSE, TRUE, 0);
	  gtk_widget_show (hbox3);
	  
	  ei_ma2_check = gtk_check_button_new_with_label (label_ma2);
	  gtk_box_pack_start (GTK_BOX (hbox3), ei_ma2_check, FALSE, TRUE, 0);
	  gtk_widget_set_usize (GTK_WIDGET (ei_ma2_check), 65, 0);
	  gtk_widget_show(ei_ma2_check);
	  
	  ei_ma2_combo = gtk_combo_new ();
      	  gtk_combo_set_popdown_strings (GTK_COMBO (ei_ma2_combo), moving_type_list);
      	  gtk_box_pack_start (GTK_BOX (hbox3), ei_ma2_combo, FALSE, TRUE, 0);
      	  gtk_widget_show (ei_ma2_combo);
	  
	  ei_ma2_spinner = gtk_spin_button_new(adj2 ,0, 0);
	  gtk_box_pack_start (GTK_BOX (hbox3), ei_ma2_spinner, FALSE, TRUE, 0);
	  gtk_widget_set_usize (GTK_WIDGET (ei_ma2_spinner), 50, 0);
	  gtk_widget_show(ei_ma2_spinner);
	  
	  hbox4 = gtk_hbox_new (FALSE, 10);
  	  gtk_box_pack_start (GTK_BOX (vbox2), hbox4, FALSE, TRUE, 0);
	  gtk_widget_show (hbox4);
	  
	  ei_ma3_check = gtk_check_button_new_with_label (label_ma3);
	  gtk_box_pack_start (GTK_BOX (hbox4), ei_ma3_check, FALSE, TRUE, 0);
	  gtk_widget_set_usize (GTK_WIDGET (ei_ma3_check), 65, 0);
	  gtk_widget_show(ei_ma3_check);
	  
	  ei_ma3_combo = gtk_combo_new ();
      	  gtk_combo_set_popdown_strings (GTK_COMBO (ei_ma3_combo), moving_type_list);
      	  gtk_box_pack_start (GTK_BOX (hbox4), ei_ma3_combo, FALSE, TRUE, 0);
      	  gtk_widget_show (ei_ma3_combo);
	  
	  ei_ma3_spinner = gtk_spin_button_new(adj3 ,0, 0);
	  gtk_box_pack_start (GTK_BOX (hbox4), ei_ma3_spinner, FALSE, TRUE, 0);
	  gtk_widget_set_usize (GTK_WIDGET (ei_ma3_spinner), 50, 0);
	  gtk_widget_show(ei_ma3_spinner);

	  config.edit_indicators_window_open = 1;
	  update_indicator_window();
	  gtk_signal_connect (GTK_OBJECT (ei_ma_check), "toggled",
			   		  GTK_SIGNAL_FUNC (ei_ma_checked), NULL);
	  gtk_signal_connect (GTK_OBJECT (ei_ma2_check), "toggled",
			   		  GTK_SIGNAL_FUNC (ei_ma2_checked), NULL);
	  gtk_signal_connect (GTK_OBJECT (ei_ma3_check), "toggled",
			   		  GTK_SIGNAL_FUNC (ei_ma3_checked), NULL);
			   		  
	  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (ei_ma_combo)->entry), "changed",
			   		  GTK_SIGNAL_FUNC (ei_ma_combo_changed), NULL);
	  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (ei_ma2_combo)->entry), "changed",
			   		  GTK_SIGNAL_FUNC (ei_ma2_combo_changed), NULL);
	  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (ei_ma3_combo)->entry), "changed",
			   		  GTK_SIGNAL_FUNC (ei_ma3_combo_changed), NULL);
			   		  
	  gtk_signal_connect (GTK_OBJECT (ei_ma_spinner), "changed",
			   		  GTK_SIGNAL_FUNC (ei_ma_spinner_changed), NULL);
	  gtk_signal_connect (GTK_OBJECT (ei_ma2_spinner), "changed",
			   		  GTK_SIGNAL_FUNC (ei_ma2_spinner_changed), NULL);
	  gtk_signal_connect (GTK_OBJECT (ei_ma3_spinner), "changed",
			   		  GTK_SIGNAL_FUNC (ei_ma3_spinner_changed), NULL);
			   		  
	  gtk_widget_show (edit_indicator_window);
    }
    
    g_string_free(tstring, TRUE);
}
