/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "logo.xpm"



GtkWidget *image1;
GtkWidget *image2;
GtkWidget *frame2;

static GtkStyle *style;
static GdkPixmap *logo_pixmap;
static GdkBitmap *logo_mask;



void destroy_about_dialog(GtkWidget *dialog)
{
   gtk_widget_destroy(dialog);
}



void get_about_dialog(GtkWidget *widget, gpointer data)
{

	
	GtkWidget *dialog;
	GtkWidget *frame, *box, *table, *hbox, *bbox;
	GtkRequisition requisition;

	/* creating about dialog itself */
	dialog = gtk_window_new(GTK_WINDOW_POPUP);
	gtk_signal_connect_object(GTK_OBJECT(dialog),
		"delete_event",
		GTK_SIGNAL_FUNC(destroy_about_dialog),
		GTK_OBJECT(dialog));
	gtk_grab_add(dialog);

	if (logo_pixmap == NULL)
	{
		gtk_widget_realize(dialog);
		style = gtk_widget_get_style(dialog);
		logo_pixmap = gdk_pixmap_create_from_xpm_d(
			dialog->window,
			&logo_mask, &style->bg[GTK_STATE_NORMAL],
			(gchar **)logo_xpm);
		gtk_widget_unrealize(dialog);
	}
	
	/* creating labels & pixmap and add them into a box */
	box = gtk_vbox_new(FALSE, 2);
	gtk_container_border_width(GTK_CONTAINER(box), 5);
	gtk_widget_show(box);

	frame2 = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(box), frame2, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type( GTK_FRAME(frame2), GTK_SHADOW_NONE );
	gtk_widget_show(frame2);

	image1 = gtk_pixmap_new(logo_pixmap, logo_mask);
	gtk_widget_show(image1);
	gtk_container_add(GTK_CONTAINER(frame2), image1);
	
	widget = gtk_label_new("version 0.09");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);
	
	widget = gtk_label_new("");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);

	widget = gtk_label_new("Copyright (C) 1999 Mathieu VILLEGAS ");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);
	
	widget = gtk_label_new("gtktalog@caramail.com");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);
	
	widget = gtk_label_new("");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);

	widget = gtk_label_new("http://www.geocities.com/SiliconValley/Bit/2458/");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);

	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);
	gtk_container_add(GTK_CONTAINER(frame), box);
	

	box = gtk_vbox_new(FALSE, 2);
	gtk_widget_show(box);
	

	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, FALSE, 0);
	


	table = gtk_table_new(2, 1, FALSE);
	gtk_widget_show(table);
	gtk_table_attach(
		GTK_TABLE(table),
		box,
		0, 1, 0, 1,
		0, 0, 3, 3);

	/* creating button */
	bbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(bbox);
	

	
	widget = gtk_button_new_with_label ("          Ok          ");

	gtk_widget_show(widget);
	
	gtk_signal_connect_object(GTK_OBJECT(widget),
		"clicked",
		GTK_SIGNAL_FUNC(destroy_about_dialog),
		GTK_OBJECT(dialog));
	
	/* creating hbox and adding button */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	
	/* adding hbox into the table */
	gtk_table_attach(
		GTK_TABLE(table),
		hbox,
		0, 1, 1, 2,
		0, 0, 3, 3);
	
	/* creating the main frame, and add frame into it */
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(frame);
	
	/* Finally, don't forget to add the main frame into the dialog :) */
	gtk_container_add(GTK_CONTAINER(dialog), frame);
	
	gtk_widget_size_request(dialog, &requisition);
	gtk_widget_set_uposition(
		dialog,
		(gdk_screen_width() - requisition.width) / 2,
		(gdk_screen_height() - requisition.height) / 2);
	
//	timer = gtk_timeout_add (500,(GtkFunction) timer_anim, NULL);//pas bon, mais trouve pas celui a mettre

	gtk_widget_show_all(dialog); 
}
