/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <fnmatch.h>

#include "savecat.h"
#include "loadcat.h"
#include "report.h"
#include "search.h"
#include "interface.h"
#include "clean.h"
#include "categories.h"
#include "selectdir.h"
#include "addisk.h"


gchar **filename_list;

//extern GtkWidget window;
extern char *load_filename;

void exec_command(GtkWidget *w,gpointer btdata)
{
  switch((int)btdata)
    {
    case 0:
      open_search_dialog(w);
      break;
    case 1:
      show_select_dir_win(w);
      break; 
    case 2:
      open_cat(w,NULL);
      break;  
    case 3:
      fast_save(w,NULL);
      break;  
    case 4:
      save_cat(w,NULL);
      break;  
    case 5:
      edit_categories(w);
      break;  
    case 6:
      clean_description(w);
      break;  
    case 7:
      quit_prog(w,NULL); 
      break;  
    case 8:
      new_file(w,NULL); 
      break; 
    case 9:
      open_report_dialog(w,NULL); 
      break; 
    case 10:
      fast_add_disk(w,NULL); 
      break; 
    default:
      load_filename = g_strdup(filename_list[(int)btdata -11]);
      have_to_load = 1;
      new_file(w,btdata);
      return;
    }
  return;
}


void add_vbar(GtkWidget *parent_box)
{
  GtkWidget *vbar;

   vbar=gtk_vseparator_new();
   gtk_box_pack_start (GTK_BOX (parent_box), vbar, FALSE, TRUE, 0);
   gtk_widget_show(vbar);
}


void add_button( GtkWidget *parent, GtkWidget *parent_box,
                          gchar     *xpm_filename,
                          gchar     *label_text, int type ,int action)
{
    GtkWidget *box1;
    GtkWidget *label;
    GtkWidget *bpixmapwid;
    GdkPixmap *bpixmap;
    GdkBitmap *bmask;
    GtkWidget *button;


    button = gtk_button_new ();
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
			GTK_SIGNAL_FUNC (exec_command), (gpointer *) action);

    gtk_button_set_relief((GtkButton *)button, GTK_RELIEF_NONE);

    box1 = gtk_vbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (box1), 0);
    if ((type == 1)||(type == 2))
      {
	bpixmap = gdk_pixmap_create_from_xpm((GdkWindow*)window->window, &bmask, NULL,xpm_filename);
	bpixmapwid = gtk_pixmap_new (bpixmap, bmask );
	gtk_box_pack_start (GTK_BOX (box1), bpixmapwid, FALSE, FALSE, 0);
	gtk_widget_show(bpixmapwid);
      }
    
    if ((type == 0)||(type == 2))
      {
	label = gtk_label_new (label_text);
	gtk_box_pack_start (GTK_BOX (box1), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
      }
      
    gtk_container_add (GTK_CONTAINER (button), box1);
    
    gtk_widget_show(box1);
    gtk_widget_show(button);

    gtk_box_pack_start (GTK_BOX (parent_box), button, FALSE, FALSE, 0);

    return;
}



void enable_button_bar(GtkWidget *main_window, GtkWidget *main_box)
{
  GtkWidget *hbox;
  int hbox_is_valid = 0;
  guchar *home;
  gchar *buttonbar_dir;
  gchar *buttonbar_file;
  FILE *file;
  char temp[101];
  int type;
  gchar pixname[100];
  gchar texte[100];
  gchar filename[200];
  int nb_filename = 0;

   if ((home = getenv("HOME")) == NULL)
    {
//      rc_initialized = FALSE;
      return;
    }
   buttonbar_dir = g_strdup( home);
   if (buttonbar_dir[strlen(buttonbar_dir) - 1] != '/') buttonbar_dir = g_strconcat(buttonbar_dir,"/",NULL);
   buttonbar_dir = g_strconcat(buttonbar_dir,".gtktalog/",NULL);
   buttonbar_file = g_strconcat(buttonbar_dir,"buttonbar.conf",NULL);
   
   if((file = fopen(buttonbar_file,"r")) == NULL)
     {
       printf("can't find button bar config file: %s\n", buttonbar_file);
       printf("Trying in %s \n", g_strconcat(PREFIX, "/share/gtktalog/buttonbar.conf",NULL));
       if((file = fopen(g_strconcat(PREFIX, "/share/gtktalog/buttonbar.conf",NULL),"r")) == NULL)
	 {
	   printf("can't find button bar config file!\n");
	   printf("No button bar is loaded!\n");
	   return;
	 }
     }
   
   
   fgets(temp,100,file);
   temp[strlen(temp)-1] = '\0';
   if (fnmatch("use_text*",temp,0) == 0) type = 0;
   else if(fnmatch("use_pixmap*",temp,0) == 0) type = 1;
   else if(fnmatch("use_pixtext*",temp,0) == 0) type = 2;
   else return;
   
   hbox = gtk_hbutton_box_new();
   gtk_button_box_set_layout (GTK_BUTTON_BOX (hbox), GTK_BUTTONBOX_START);
   gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 0);
   gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbox), 0, 0);
      
   gtk_container_border_width(GTK_CONTAINER(hbox), 1);
   gtk_box_pack_start(GTK_BOX(main_box),hbox,FALSE, FALSE, 0 );
   gtk_widget_show(hbox);
   
   fgets(temp,100,file);
   temp[strlen(temp)-1] = '\0';
   while(strlen(temp)>0)
     {
       if (fnmatch("find*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
		   texte[strlen(texte) -1] = '\0';
	     } 
	   add_button( main_window, hbox, pixname, texte, type , 0); 
	 }
       else if (fnmatch("add_disk*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     } 
	   add_button( main_window, hbox, pixname, texte, type , 1); 
	 }    
       else if (fnmatch("load_catalog*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     } 
	   add_button( main_window, hbox, pixname, texte, type , 2); 
	 }    
       else if (fnmatch("fast_load*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     }
	   if (nb_filename == 0) filename_list = (gchar **)malloc(sizeof(char *));
	   else filename_list = (gchar **)realloc(filename_list,(nb_filename + 1)*sizeof(char *));
	   fgets(filename,200,file);
	   filename[strlen(filename)-1] = '\0';
	   filename_list[nb_filename] = g_strdup(filename);
	   add_button( main_window, hbox, pixname, texte, type , 11+nb_filename);
	   nb_filename++;
	 }  
       else if (fnmatch("fast_save*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     }
	   add_button( main_window, hbox, pixname, texte, type , 3); 
	 }  
       else if (fnmatch("save_as*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     }
	   add_button( main_window, hbox, pixname, texte, type , 4); 
	 }  
       else if (fnmatch("edit_categories*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     }
	   add_button( main_window, hbox, pixname, texte, type , 5); 
	 } 
       else if (fnmatch("clean_descriptions*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     }
	   add_button( main_window, hbox, pixname, texte, type , 6); 
	 } 
       else if (fnmatch("exit*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     }
	       add_button( main_window, hbox, pixname, texte, type , 7); 
	 } 
       else if (fnmatch("new_catalog*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     }
	   add_button( main_window, hbox, pixname, texte, type , 8); 
	 } 
       else if (fnmatch("create_report*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     }
	   add_button( main_window, hbox, pixname, texte, type , 9); 
	 }
       else if (fnmatch("fast_add_disk*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   if ((type == 1)||(type == 2))
	     {
	       fgets(pixname,100,file);
	       pixname[strlen(pixname)-1] = '\0';
	     } 
	   if ((type == 0)||(type == 2)) 
	     {
	       fgets(texte,100,file);
	       texte[strlen(texte) -1] = '\0';
	     }
	   add_button( main_window, hbox, pixname, texte, type , 10); 
	 }
 
       else if (fnmatch("vertical_separator*",temp,0) == 0)
	 {
	   hbox_is_valid = 1;
	   add_vbar(hbox);
	 }
       fgets(temp,100,file);
       if (strlen(temp) > 0) temp[strlen(temp)-1] = '\0';
     }
   fclose(file); 
   if (hbox_is_valid == 0) gtk_widget_destroy(hbox);

}

