#include <gtk/gtk.h>
#include <stdlib.h>
#include "stdio.h"

#include "data.h"
#include "edit.h"

GtkWidget *cat_clist;
GtkWidget *cat_window;
gint selected_row;
GtkWidget *edit_entry;
unsigned long int *cat_used;


extern int edit_box_existe;


void show_list()
{
  int i;
  char *temp[2] = { "" , "" };
 
  temp[1] = (char *)malloc(15*sizeof(char));
  gtk_clist_clear((GtkCList *)cat_clist );
  for(i=1;i<nb_categories;i++)
    {
      temp[0] = g_strdup(categories[i]);
      sprintf(temp[1],"%lu",cat_used[i]);
      gtk_clist_append((GtkCList *)cat_clist, temp);
    }
}


void cancel_clicked(GtkWidget *w)
{
  gtk_widget_destroy(w);
  return;
}

void add_the_categorie(GtkWidget *w)
{
  char *data;

  fflush(stdout);
  data = gtk_entry_get_text((GtkEntry *) edit_entry );
  categories = (char **)realloc(categories,(nb_categories +1)*sizeof(char *));
  categories[nb_categories] =(char *) malloc((strlen(data) +1)*sizeof(char));
  strcpy(categories[nb_categories],data);
  nb_categories++;
  cat_used = (unsigned long int *)realloc(cat_used,nb_categories*sizeof(unsigned long int));
  cat_used[nb_categories -1]=0;
  gtk_widget_destroy(w);
  show_list();
  if (edit_box_existe == 1)  update_cat_box();
  is_modified = 1;
  return;
}


void modifie_categorie(GtkWidget *w)
{
  char *data;

  data = gtk_entry_get_text((GtkEntry *) edit_entry ); 
  categories[selected_row +1] = (char *)realloc(categories[selected_row +1],(strlen(data) +1)*sizeof(char *));
  strcpy(categories[selected_row +1],data);
  gtk_widget_destroy(w);
  show_list();
  if (edit_box_existe == 1)  update_cat_box();
  is_modified = 1;
  return;
}



void show_edit_box(gint action)
{
  GtkWidget *edit_window;
  GtkWidget *vbox, *hbox;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;
  
  edit_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize( GTK_WIDGET (edit_window), 200, 50);
  if (action == 1) gtk_window_set_title(GTK_WINDOW (edit_window), "Add new category");
  if(action == 2) gtk_window_set_title(GTK_WINDOW (edit_window), "Edit selected category");
  gtk_signal_connect(GTK_OBJECT (edit_window), "delete_event",
		     cancel_clicked, NULL);
  
  gtk_grab_add(edit_window);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (edit_window), vbox);
  gtk_widget_show (vbox);
  
  edit_entry = gtk_entry_new_with_max_length (50);
  /*gtk_signal_connect(GTK_OBJECT(edit_entry), "activate",
    GTK_SIGNAL_FUNC(enter_callback),
    edit_entry);*/
  if(action == 2) gtk_entry_set_text (GTK_ENTRY (edit_entry), categories[selected_row +1]);
  gtk_entry_select_region (GTK_ENTRY (edit_entry),
			   0, GTK_ENTRY(edit_entry)->text_length);
  gtk_box_pack_start (GTK_BOX (vbox), edit_entry, TRUE, TRUE, 0);
  gtk_widget_show (edit_entry);
  
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (vbox), hbox);
  gtk_widget_show (hbox);
  
  
  button_ok = gtk_button_new_with_label ("Ok");
  if (action == 1)
    {
      gtk_signal_connect_object (GTK_OBJECT (button_ok), "clicked",
				 GTK_SIGNAL_FUNC(add_the_categorie),
				 GTK_OBJECT (edit_window));
    }
  if (action == 2)
    {
      gtk_signal_connect_object (GTK_OBJECT (button_ok), "clicked",
				 GTK_SIGNAL_FUNC(modifie_categorie),
				 GTK_OBJECT (edit_window));
    }
  gtk_box_pack_start (GTK_BOX (hbox), button_ok, TRUE, TRUE, 0);
  
  
  button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect_object (GTK_OBJECT (button_cancel), "clicked",
			       GTK_SIGNAL_FUNC(cancel_clicked),
			     GTK_OBJECT (edit_window));
  gtk_box_pack_start (GTK_BOX (hbox), button_cancel, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button_cancel);
  gtk_widget_show (button_cancel);
  
  
  GTK_WIDGET_SET_FLAGS (button_ok, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button_ok);
  gtk_widget_show (button_ok);
  
  gtk_widget_show(edit_window);
  
  return;
}




void button_add_clicked( gpointer data )
{
  show_edit_box(1);
  return;
}


void button_edit_clicked( gpointer data )
{
  if (selected_row != -1) show_edit_box(2);
  return; 
}



void recursive_change_cat(Folder *folder,int row)
{
  int i;

  if(folder->categorie == row) folder->categorie = 0;
  else if(folder->categorie > row) folder->categorie--;
  for(i=0;i<folder->nb_folders;i++) recursive_change_cat(&folder->folders[i],row);
  for(i=0;i<folder->nb_files;i++)
    {
     if(folder->files[i].categorie == row) folder->files[i].categorie = 0;
     else if(folder->files[i].categorie > row) folder->files[i].categorie--; 
    }
  return;
}


/* The user clicked the "Hide/Show titles" button. */
void button_delete_clicked( gpointer data )
{
    if(selected_row != -1)
      {
	int i;
	free(categories[selected_row +1]);
	for(i=(selected_row+1);i<(nb_categories -1);i++)
	  {
	    categories[i] = categories[i+1];
	    cat_used[i] = cat_used[i+1];
	  }
	categories = (char **)realloc(categories,(nb_categories -1)*sizeof(char *));
	nb_categories--;
	recursive_change_cat(&racine,selected_row+1);
	show_list();
	if (edit_box_existe == 1)  update_cat_box();
      }
    is_modified = 1;
    return;
}


void cat_selected( GtkWidget *clist, gint row, gint column, GdkEventButton *event, gpointer data)
{
  selected_row = row;
  return;
}


void cat_unselected( GtkWidget *clist, gint row, gint column, GdkEventButton *event, gpointer data)
{
  selected_row = -1;
  return;
}



void scan_for_cat(Folder *folder)
{
  int i;

  cat_used[folder->description]++;
  for(i=0;i<folder->nb_folders;i++)  scan_for_cat(&folder->folders[i]);
  for(i=0;i<folder->nb_files;i++) cat_used[folder->files[i].categorie]++;
}


int edit_categories( GtkWidget *w)
{                                  
  int i;
  GtkWidget *scrolled_window;
  GtkWidget *vbox, *hbox;
  GtkWidget *button_add, *button_edit, *button_delete, *button_exit;    
  gchar *titles[2] = { "Name", "Use"};

  selected_row = -1;

  free(cat_used);
  cat_used = NULL;
  cat_used = (unsigned long int *)malloc(nb_categories*sizeof(unsigned long int));
  for(i=0;i<nb_categories;i++) cat_used[i] = 0;
  scan_for_cat(&racine);

  cat_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(GTK_WIDGET(cat_window), 300, 150);

  gtk_window_set_title(GTK_WINDOW(cat_window), "Category editor");
  gtk_signal_connect(GTK_OBJECT(cat_window),
		     "destroy",
		     cancel_clicked,
		     NULL);
   gtk_grab_add(cat_window);


  vbox=gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
  gtk_container_add(GTK_CONTAINER(cat_window), vbox);
  gtk_widget_show(vbox);
  
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				  GTK_POLICY_AUTOMATIC, 
				  GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(vbox), scrolled_window, TRUE, TRUE, 0);
  gtk_widget_show(scrolled_window);

  cat_clist = gtk_clist_new_with_titles(2,titles);
  
  gtk_clist_set_selection_mode((GtkCList *)cat_clist, GTK_SELECTION_SINGLE);
 
  gtk_signal_connect(GTK_OBJECT(cat_clist), "select_row",
		     GTK_SIGNAL_FUNC(cat_selected),
		     NULL);
  gtk_signal_connect(GTK_OBJECT(cat_clist), "unselect_row",
		     GTK_SIGNAL_FUNC(cat_unselected),
		     NULL);

  gtk_clist_set_shadow_type (GTK_CLIST(cat_clist), GTK_SHADOW_OUT);
  
  gtk_clist_set_column_width (GTK_CLIST(cat_clist), 0, 150);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window), cat_clist);

  gtk_widget_show(cat_clist);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
  gtk_widget_show(hbox);
  
  button_add = gtk_button_new_with_label("Add");
  button_edit = gtk_button_new_with_label("Edit");
  button_delete = gtk_button_new_with_label("Delete");
  button_exit = gtk_button_new_with_label("Exit");

  gtk_box_pack_start(GTK_BOX(hbox), button_add, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), button_edit, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), button_delete, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), button_exit, TRUE, TRUE, 0);


  gtk_signal_connect_object(GTK_OBJECT(button_add), "clicked",
			    GTK_SIGNAL_FUNC(button_add_clicked),
			    (gpointer) cat_clist);
  gtk_signal_connect_object(GTK_OBJECT(button_edit), "clicked",
			    GTK_SIGNAL_FUNC(button_edit_clicked),
			    (gpointer) cat_clist);
  gtk_signal_connect_object(GTK_OBJECT(button_delete), "clicked",
			    GTK_SIGNAL_FUNC(button_delete_clicked),
			    (gpointer) cat_clist);
  gtk_signal_connect_object(GTK_OBJECT(button_exit), "clicked",
			    GTK_SIGNAL_FUNC(cancel_clicked),
			    (gpointer) cat_window);  
    
  gtk_widget_show(button_add);
  gtk_widget_show(button_edit);
  gtk_widget_show(button_delete);
  gtk_widget_show(button_exit);

  gtk_widget_show(cat_window);

  show_list();
  
  return(0);
}

