/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

#include "data.h"
#include "edit.h"
#include "categories.h"
#include "erreur.h"

GtkWidget *fold_entry;
GtkWidget *categorie_entry;
GtkWidget *description_entry;
GtkWidget *edit_window;
GtkWidget *cat_combo;
GtkWidget *cat_box;
GtkWidget *cat_ed;
GtkWidget *desc_combo;
int recursive_cat, recursive_desc, recursive;

extern Folder *selected_clist_folder;
extern GtkWidget *clist;
int edit_box_existe = 0;


int folder_exist_in(Folder *folder, char *name, GtkWidget *widget)
{
  int i;
  for(i=0;i<folder->nb_folders;i++)
    {
      if(strcmp(folder->folders[i].name,name) == 0)
	{
	  if(is_disk(&folder->folders[i]) == 1) erreur_dialog(widget, "A disk with this","name already exist!","Error!");
	  else if((is_folder(&folder->folders[i]) == 1)||(is_link(&folder->folders[i]) == 1)) erreur_dialog(widget, "A Folder with this","name already exist!","Error!");
	  return(1);
	}
    }
  return(0);
}


int file_exist_in(Folder *folder, char *name, GtkWidget *widget)
{
  int i;
  for(i=0;i<folder->nb_files;i++)
    {
      if(strcmp(folder->files[i].name,name) == 0)
	{
	  erreur_dialog(widget, "A file with this ","name already exit!","Error!");
	  return(1);
	}
    }
  return(0);
}



void recursive_change(Folder *folder,unsigned char cat, unsigned short int desc)
{
  int i;
 
  if(recursive_cat == 1) folder->categorie = cat;
  if(recursive_desc == 1) folder->description = desc;
  if (folder->nb_folders > 0)
    {
      for(i=0;i<folder->nb_folders;i++)
	{
	  recursive_change(&folder->folders[i], cat, desc);
	}
    }
  if (folder->nb_files > 0)
    {
      for(i=0;i<folder->nb_files;i++)
	{
	  if(recursive_cat == 1) folder->files[i].categorie = cat;
	  if(recursive_desc == 1) folder->files[i].description = desc;
	}
    } 
}



void reorganise()
{
  int i = 0;
  int fin;
  int j;
 
if (is_file(selected_folder) == 0)
  {
    while(strcmp(selected_folder->name,selected_folder->parent->folders[i].name) != 0)i++;
    selected_folder->parent->folders = (Folder *)realloc(selected_folder->parent->folders,(selected_folder->parent->nb_folders +1)*sizeof(Folder));
    selected_folder->parent->folders[selected_folder->parent->nb_folders] = selected_folder->parent->folders[i];
    
    if ((i < (selected_folder->parent->nb_folders -1))&&(strcmp(selected_folder->name,selected_folder->parent->folders[i+1].name) > 0))
      {
	fin = 0;
	while((fin == 0)&&(i<selected_folder->parent->nb_folders-1))
	{
	  if (strcmp(selected_folder->parent->folders[selected_folder->parent->nb_folders].name,selected_folder->parent->folders[i+1].name) > 0) 
	    {
	      selected_folder->parent->folders[i] = selected_folder->parent->folders[i+1];
	      i++;
	    }
	  else
	    {
	      fin = 1;
	    }
	} 
	selected_folder->parent->folders[i] = selected_folder->parent->folders[selected_folder->parent->nb_folders];
	selected_folder->parent->folders = (Folder *)realloc(selected_folder->parent->folders,(selected_folder->parent->nb_folders)*sizeof(Folder));
      }
    else if ((i > 0)&&(strcmp(selected_folder->name,selected_folder->parent->folders[i-1].name) < 0))
      {  
	fin = 0;
	while((fin == 0)&&(i > 0))
	  {
	    if (strcmp(selected_folder->parent->folders[selected_folder->parent->nb_folders].name,selected_folder->parent->folders[i-1].name) < 0) 
	      {
		selected_folder->parent->folders[i] = selected_folder->parent->folders[i-1];
		i--;
	      }
	    else
	      {
		fin = 1;
	      }
	  }
	if(i < 0) i = 0;// je sais pas pkoi des fois ca passe en desous de 0
	selected_folder->parent->folders[i] = selected_folder->parent->folders[selected_folder->parent->nb_folders];
	selected_folder->parent->folders = (Folder *)realloc(selected_folder->parent->folders,(selected_folder->parent->nb_folders)*sizeof(Folder));
      }
    
    /* utile, car il faut restituer les parents, sinon, ca marche pas :o( */
    for(j=0;j<selected_folder->parent->folders[i].nb_folders;j++)
      {
	selected_folder->parent->folders[i].folders[j].parent = &selected_folder->parent->folders[i];
      }
    for(j=0;j<selected_folder->parent->folders[i].nb_files;j++)
      {
	selected_folder->parent->folders[i].files[j].parent = &selected_folder->parent->folders[i];
      }
  }
/*si c'est un fichier, on fait: */
else
  {
    while(strcmp(selected_folder->name,selected_folder->parent->files[i].name) != 0)i++;
    selected_folder->parent->files = (Folder *)realloc(selected_folder->parent->files,(selected_folder->parent->nb_files +1)*sizeof(Folder));
    selected_folder->parent->files[selected_folder->parent->nb_files] = selected_folder->parent->files[i];
    
    if ((i < (selected_folder->parent->nb_files -1))&&(strcmp(selected_folder->name,selected_folder->parent->files[i+1].name) > 0))
      {
	fin = 0;
	while((fin == 0)&&(i<selected_folder->parent->nb_files-1))
	{
	  if (strcmp(selected_folder->parent->files[selected_folder->parent->nb_files].name,selected_folder->parent->files[i+1].name) > 0) 
	    {
	      selected_folder->parent->files[i] = selected_folder->parent->files[i+1];
	      i++;
	    }
	  else
	    {
	      fin = 1;
	    }
	} 
	selected_folder->parent->files[i] = selected_folder->parent->files[selected_folder->parent->nb_files];
	selected_folder->parent->files = (Folder *)realloc(selected_folder->parent->files,(selected_folder->parent->nb_files)*sizeof(Folder));
      }
    else if ((i > 0)&&(strcmp(selected_folder->name,selected_folder->parent->files[i-1].name) < 0))
      {  
	fin = 0;
	while((fin == 0)&&(i > 0))
	  {
	    if (strcmp(selected_folder->parent->files[selected_folder->parent->nb_files].name,selected_folder->parent->files[i-1].name) < 0) 
	      {
		selected_folder->parent->files[i] = selected_folder->parent->files[i-1];
		i--;
	      }
	    else
	      {
		fin = 1;
	      }
	  }
	if(i < 0) i = 0;// je sais pas pkoi des fois ca passe en desous de 0
	selected_folder->parent->files[i] = selected_folder->parent->files[selected_folder->parent->nb_files];
	selected_folder->parent->files = (Folder *)realloc(selected_folder->parent->files,(selected_folder->parent->nb_files)*sizeof(Folder));
      }
    
    /* utile, car il faut restituer les parents, sinon, ca marche pas :o( */
    /*for(j=0;j<selected_folder->parent->files[i].nb_files;j++)
      {
	selected_folder->parent->files[i].files[j].parent = &selected_folder->parent->files[i];
      }
    for(j=0;j<selected_folder->parent->files[i].nb_files;j++)
      {
	selected_folder->parent->files[i].files[j].parent = &selected_folder->parent->files[i];
      }*/
  }
}


void ok_clicked(GtkWidget *w)
{
  gchar *entry_text,*entry_text2, *entry_text3 ;
  unsigned short int desc;
  unsigned char cat;

  
  if (selected_folder != NULL)
    { 
      if ((recursive_cat == 1)||(recursive_desc == 1)) recursive = 1;
      else recursive = 0;
    
      entry_text =   gtk_entry_get_text(GTK_ENTRY(fold_entry)); 
      entry_text2 =  gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cat_combo)->entry));
      entry_text3 =  gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(desc_combo)->entry));
      
      if ((strcmp(selected_folder->name,entry_text) != 0)&&((is_folder(selected_folder) == 1)||(is_link(selected_folder) == 1)||(is_disk(selected_folder) == 1)))
	{
	  if (folder_exist_in(selected_folder->parent, entry_text, w) == 1) return;
	}
      else if ((strcmp(selected_folder->name,entry_text) != 0)&&(is_file(selected_folder) == 1))
	{
	  if (file_exist_in(selected_folder->parent, entry_text, w) == 1) return;
	}

      cat = add_categorie(entry_text2);
      desc =  change_description(selected_folder,selected_folder->description,recursive,entry_text3);

      selected_folder->categorie = cat;
      selected_folder->description = desc;
      if (recursive == 1)
	{
	  recursive_change(selected_folder, cat, desc);
	}

      if ((strcmp(selected_folder->name,entry_text) != 0)/*&&(is_disk(selected_folder) == 1)*/)
	{
	  selected_folder->name = (char *)realloc(selected_folder->name,(strlen(entry_text) +1)*sizeof(char));
	  strcpy(selected_folder->name,entry_text);
	  /*if(is_disk(selected_folder) == 1)*/ reorganise();

	  gtk_widget_destroy(edit_window);
	  
	  if ((is_folder(selected_folder) == 1)||(is_disk(selected_folder) == 1)||(is_link(selected_folder) == 1)) update_tree();
	  if (is_disk(selected_folder) == 0)
	    {
	      gtk_clist_clear((GtkCList *)clist);
	      list_folder(selected_folder->parent);
	    }
	  selected_folder = NULL;
	}
      else
	{
	  gtk_widget_destroy(edit_window);
	  gtk_clist_clear((GtkCList *)clist);
	  list_folder(selected_folder->parent);
	  selected_folder = NULL;
	}
    }
  edit_box_existe = 0;
  is_modified = 1;
}





void set_recursive_cat (GtkWidget *checkbutton,GtkWidget *pouet)
{
  if (recursive_cat == 0) recursive_cat = 1;
  else recursive_cat = 0;
}


void set_recursive_desc (GtkWidget *checkbutton,GtkWidget *pouet)
{
  if (recursive_desc == 0) recursive_desc = 1;
  else recursive_desc = 0;
}




void delete_folder(GtkWidget *w)
{ 
  int i,j;
  
  if(is_file(selected_folder) == 0)
    {
      i = 0;
      while(strcmp(selected_folder->name,selected_folder->parent->folders[i].name) != 0) i++;
      if (selected_folder->parent->nb_folders > 1)
	{
	  for(j=i;j<(selected_folder->parent->nb_folders - 1);j++)
	    {
	      selected_folder->parent->folders[j] = selected_folder->parent->folders[j+1];
	    }
	}
      selected_folder->parent->folders = (Folder *)realloc(selected_folder->parent->folders,(selected_folder->parent->nb_folders -1)*sizeof(Folder));
      selected_folder->parent->nb_folders = selected_folder->parent->nb_folders - 1;
      if (edit_box_existe == 1) gtk_widget_destroy(edit_window);
      clear_all(w, NULL);
      affichage_tree();
      if (is_disk(selected_folder) == 0)
	{
	  gtk_clist_clear((GtkCList *)clist);
	  list_folder(selected_folder->parent);
	}
      is_modified = 1;
      
      // free(selected_folder); //plante! va savoir comment faut detruire ce genre de truc!
      // alors je detruit pas puis on a tous plein de memoire vive a revendre, alors on s'en tape!
      selected_folder = NULL;
      
      edit_box_existe = 0;
      
    } 
  else
    {
      i = 0;
      while(strcmp(selected_folder->name,selected_folder->parent->files[i].name) != 0) i++;
      if (selected_folder->parent->nb_files > 1)
	{
	  for(j=i;j<(selected_folder->parent->nb_files - 1);j++)
	    {
	      selected_folder->parent->files[j] = selected_folder->parent->files[j+1];
	    }
	}
      selected_folder->parent->files = (Folder *)realloc(selected_folder->parent->files,(selected_folder->parent->nb_files -1)*sizeof(Folder));
      selected_folder->parent->nb_files = selected_folder->parent->nb_files - 1;
      if (edit_box_existe == 1) gtk_widget_destroy(edit_window);
      //clear_all(w, NULL);
      gtk_clist_clear((GtkCList *)clist);
      list_folder(selected_folder->parent);
      is_modified = 1;
      
      // free(selected_folder); //plante! va savoir comment faut detruire ce genre de truc!
      // alors je detruit pas puis on a tous plein de memoire vive a revendre, alors on s'en tape!
      selected_folder = NULL;
      
      edit_box_existe = 0;
      
    } 
}


void update_cat_box()
{
  int i;
  GList *cat_list;

  gtk_widget_destroy(cat_ed);
  gtk_widget_destroy(cat_combo);

  cat_combo = gtk_combo_new();   
  gtk_combo_set_value_in_list(GTK_COMBO(cat_combo), FALSE, TRUE); 
  gtk_combo_set_use_arrows_always(GTK_COMBO(cat_combo), TRUE); 
  gtk_combo_disable_activate(GTK_COMBO(cat_combo));
  gtk_box_pack_start (GTK_BOX (cat_box), cat_combo, TRUE, TRUE, 0);

  cat_list=NULL;	
  for(i=0;i<nb_categories;i++) cat_list = g_list_append(cat_list, categories[i]);
  gtk_combo_set_popdown_strings(GTK_COMBO(cat_combo), cat_list);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cat_combo)->entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(cat_combo)->entry), categories[selected_folder->categorie]);
  gtk_widget_show (cat_combo);

  cat_ed=gtk_button_new_with_label(" . . . ");
  gtk_box_pack_start(GTK_BOX(cat_box),cat_ed,FALSE,FALSE,0);
  gtk_signal_connect(GTK_OBJECT(cat_ed),"clicked",GTK_SIGNAL_FUNC(edit_categories),fold_entry);
  gtk_widget_show(cat_ed);
}


void edit_folder(GtkWidget *w)
{
  GtkWidget *vbox, *hbox, *the_box;
  GtkWidget *ok, *cancel, *delete;
  GtkWidget *frame;
  GtkWidget *check;
  //    GtkWidget *cat_box;
  //    GtkWidget *cat_ed;
  
  GList *cat_list;
  
  GList *desc_list;
  int i;
  
  edit_box_existe = 1;
  
  if (selected_folder != NULL)
    {
      edit_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_window_set_position (GTK_WINDOW (edit_window), GTK_WIN_POS_MOUSE);
      if ((is_file(selected_folder) == 1)||(is_link(selected_folder) == 1)) gtk_widget_set_usize( GTK_WIDGET (edit_window), 300,170);
      else gtk_widget_set_usize( GTK_WIDGET (edit_window), 300,210);
      if (is_disk(selected_folder) == 1)gtk_window_set_title(GTK_WINDOW (edit_window), "Edit disk");
      else if (is_link(selected_folder) == 1)gtk_window_set_title(GTK_WINDOW (edit_window), "Edit link");
      else if (is_folder(selected_folder) == 1)gtk_window_set_title(GTK_WINDOW (edit_window), "Edit folder");
      else if (is_file(selected_folder) == 1)gtk_window_set_title(GTK_WINDOW (edit_window), "Edit file");
      gtk_window_set_policy(GTK_WINDOW(edit_window), FALSE, FALSE, TRUE);
      gtk_container_border_width(GTK_CONTAINER(edit_window),10);
      gtk_signal_connect(GTK_OBJECT (edit_window), "delete_event",
			 GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(edit_window));
      
      gtk_grab_add(edit_window);
      
      vbox = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (edit_window), vbox);
      gtk_widget_show (vbox);
      /***************/	
      frame = gtk_frame_new(NULL);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      if (is_disk(selected_folder) == 1) gtk_frame_set_label( GTK_FRAME(frame), "Edit disk label" );
      else if (is_link(selected_folder) == 1)gtk_frame_set_label( GTK_FRAME(frame), "Link label" );
      else if (is_folder(selected_folder) == 1)gtk_frame_set_label( GTK_FRAME(frame), "Folder label" );
      else if (is_file(selected_folder) == 1)gtk_frame_set_label( GTK_FRAME(frame), "file label" );
      gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
      gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
      gtk_widget_show(frame);
      
      fold_entry = gtk_entry_new_with_max_length (80);
      gtk_signal_connect(GTK_OBJECT(fold_entry), "activate",
			 GTK_SIGNAL_FUNC(ok_clicked),
			 fold_entry);
      gtk_entry_set_text (GTK_ENTRY (fold_entry), selected_folder->name);
      gtk_entry_select_region (GTK_ENTRY (fold_entry),
			       0, GTK_ENTRY(fold_entry)->text_length);
      gtk_container_add(GTK_CONTAINER(frame), fold_entry);
      //	if(is_disk(selected_folder) == 0) gtk_entry_set_editable(GTK_ENTRY(fold_entry), FALSE);
      gtk_widget_show (fold_entry);
      
      /***********/	
      frame = gtk_frame_new(NULL);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      if (is_disk(selected_folder) == 1) gtk_frame_set_label( GTK_FRAME(frame), "Change disk category" );
      else if (is_link(selected_folder) == 1)gtk_frame_set_label( GTK_FRAME(frame), "Change link category" );
      else if (is_folder(selected_folder) == 1)gtk_frame_set_label( GTK_FRAME(frame), "Change folder category" );
      else if (is_file(selected_folder) == 1)gtk_frame_set_label( GTK_FRAME(frame), "Change file category" );
      gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
      gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
      gtk_widget_show(frame);
      
      cat_box = gtk_hbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), cat_box);
      gtk_widget_show (cat_box);
      
      
      
      cat_combo = gtk_combo_new();                                                                           
      gtk_combo_set_value_in_list(GTK_COMBO(cat_combo), FALSE, TRUE);                                        
      gtk_combo_set_use_arrows_always(GTK_COMBO(cat_combo), TRUE);                                           
      gtk_combo_disable_activate(GTK_COMBO(cat_combo));                                                      
      gtk_box_pack_start (GTK_BOX (cat_box), cat_combo, TRUE, TRUE, 0);
      cat_list=NULL;	
      for(i=0;i<nb_categories;i++) cat_list = g_list_append(cat_list, categories[i]);
      gtk_combo_set_popdown_strings(GTK_COMBO(cat_combo), cat_list);
      gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cat_combo)->entry), FALSE);
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(cat_combo)->entry), categories[selected_folder->categorie]);
      gtk_widget_show (cat_combo);
      
      
      cat_ed=gtk_button_new_with_label(" . . . ");
      gtk_box_pack_start(GTK_BOX(cat_box),cat_ed,FALSE,FALSE,0);
      gtk_signal_connect(GTK_OBJECT(cat_ed),"clicked",GTK_SIGNAL_FUNC(edit_categories),fold_entry);
      gtk_widget_show(cat_ed);
      
      
	
      /***********/	
      frame = gtk_frame_new(NULL);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      gtk_frame_set_label( GTK_FRAME(frame), "Edit description" );
      gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
      gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
      gtk_widget_show(frame);
      
      desc_combo = gtk_combo_new();                                                                           
      gtk_combo_set_value_in_list(GTK_COMBO(desc_combo), FALSE, TRUE);                                        
      gtk_combo_set_use_arrows_always(GTK_COMBO(desc_combo), TRUE);                                           
      gtk_combo_disable_activate(GTK_COMBO(desc_combo));                                              	
      gtk_container_add(GTK_CONTAINER(frame), desc_combo);
      desc_list=NULL;	
      for(i=0;i<nb_descriptions;i++) desc_list = g_list_append(desc_list, descriptions[i]);
      gtk_combo_set_popdown_strings(GTK_COMBO(desc_combo), desc_list);
      gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(desc_combo)->entry), descriptions[selected_folder->description]);
      gtk_widget_show (desc_combo);
      
      /***********/
      if ((is_file(selected_folder) == 0)&&(is_link(selected_folder) == 0))
	{	
	  frame = gtk_frame_new(NULL);
	  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
	  gtk_frame_set_label( GTK_FRAME(frame), "Propagate in subfolders and files" );
	  gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
	  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
	  gtk_widget_show(frame);
	  
	  the_box = gtk_hbox_new (FALSE, 0);
	  gtk_container_add (GTK_CONTAINER (frame), the_box);
	  gtk_widget_show (the_box);
	  
	  check = gtk_check_button_new_with_label("Category");
	  gtk_signal_connect (GTK_OBJECT(check), "toggled",
			      GTK_SIGNAL_FUNC(set_recursive_cat),fold_entry);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);
	  gtk_box_pack_start (GTK_BOX (the_box), check, FALSE, TRUE, 0);
	  gtk_widget_show (check);
	  
	  check = gtk_check_button_new_with_label("Description");
	  gtk_signal_connect (GTK_OBJECT(check), "toggled",
			      GTK_SIGNAL_FUNC(set_recursive_desc),fold_entry);
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);
	  gtk_box_pack_start (GTK_BOX (the_box), check, FALSE, TRUE, 0);
	  gtk_widget_show (check);
	}
      
      hbox=gtk_hbutton_box_new();
      gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox),GTK_BUTTONBOX_END);
      gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox),5);
      
      ok=gtk_button_new_with_label("Ok");
      gtk_object_set_user_data(GTK_OBJECT(ok),edit_window);
      GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
      gtk_window_set_default(GTK_WINDOW(edit_window),ok);
      gtk_box_pack_start(GTK_BOX(hbox),ok,TRUE,TRUE,0);
      gtk_signal_connect(GTK_OBJECT(ok),"clicked",GTK_SIGNAL_FUNC(ok_clicked),fold_entry);
      gtk_widget_show(ok);
      
      cancel=gtk_button_new_with_label("Cancel");
      GTK_WIDGET_SET_FLAGS(cancel,GTK_CAN_DEFAULT);
      gtk_box_pack_start(GTK_BOX(hbox),cancel,TRUE,TRUE,0);
      gtk_signal_connect_object(GTK_OBJECT(cancel),"clicked",GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(edit_window));
      gtk_widget_show(cancel);
      
      
      delete=gtk_button_new_with_label("Delete");
      GTK_WIDGET_SET_FLAGS(delete,GTK_CAN_DEFAULT);
      gtk_box_pack_start(GTK_BOX(hbox),delete,TRUE,TRUE,0);
      gtk_signal_connect(GTK_OBJECT(delete),"clicked",GTK_SIGNAL_FUNC(delete_folder),fold_entry);
      gtk_widget_show(delete);
      
      
      gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
      gtk_widget_show(hbox);
      
      gtk_widget_show(edit_window);
      
      recursive_cat = 0;
      recursive_desc = 0;
      recursive = 0;
    }
}
