/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>*/

#include "error.xpm"
#include "data.h"

GtkWidget *dialog;

void destroy_exit_dialog(GtkWidget *dialog2)
{
  gtk_grab_remove(dialog);
  gtk_widget_destroy(dialog);
}


void ok_click(GtkWidget *dialog2)
{
  fast_save(dialog2, NULL);  
  gtk_grab_remove(dialog);
  gtk_widget_destroy(dialog);
  
}

void no_clicked(GtkWidget *dialog2)
{
  gtk_grab_remove(dialog);
  gtk_widget_destroy(dialog);
  if (have_to_clear == 1) 
    {
      is_modified = 0;
      new_file(dialog2, NULL);
    }
   if (have_to_quit == 1) gtk_main_quit();
}

void exit_dialog(GtkWidget *widget, gpointer data)
{
	static GtkStyle *style;
	static GdkPixmap *error_pixmap;
	static GdkBitmap *error_mask;
	
	GtkWidget *frame, *box, *table, *hbox, *bbox;
	GtkWidget *ok_button, *no_button, *cancel_button, *table2;
	GtkRequisition requisition;
	
	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog), "Warning");
	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, TRUE);
	gtk_signal_connect_object(GTK_OBJECT(dialog),
		"delete_event",
		GTK_SIGNAL_FUNC(destroy_exit_dialog),
		GTK_OBJECT(dialog));
	gtk_grab_add(dialog);

	if (error_pixmap == NULL)
	{
		gtk_widget_realize(dialog);
		style = gtk_widget_get_style(dialog);
		error_pixmap = gdk_pixmap_create_from_xpm_d(
			dialog->window,
			&error_mask, &style->bg[GTK_STATE_NORMAL],
			(gchar **)error_xpm);
		gtk_widget_unrealize(dialog);
	}
	
	/* creating labels & pixmap and add them into a box */
	box = gtk_vbox_new(FALSE, 2);
	gtk_container_border_width(GTK_CONTAINER(box), 5);
	gtk_widget_show(box);
	
	widget = gtk_pixmap_new(error_pixmap, error_mask);
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);
	
/*	widget = gtk_label_new("");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);*/
	
/*	widget = gtk_label_new("");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);*/
	
	widget = gtk_label_new("The current catalog have change!");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);
	
	widget = gtk_label_new("Save it before ?");
	gtk_widget_show(widget);
	gtk_box_pack_start(GTK_BOX(box), widget, FALSE, FALSE, 0);
	
	/* adding box into frame */
	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);
	gtk_container_add(GTK_CONTAINER(frame), box);
	
	/* creating the main box */
	box = gtk_vbox_new(FALSE, 10);
	gtk_widget_show(box);
	
	/* adding frame to main box */
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, FALSE, 0);	

	/* creating the table and add main box */
	table = gtk_table_new(2, 1, FALSE);
	gtk_widget_show(table);
	gtk_table_attach(
		GTK_TABLE(table),
		box,
		0, 1, 0, 1,
		0, 0, 3, 3);

	/* creating button */
	bbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(bbox);
	
	table2 =  gtk_table_new (10, 20, TRUE);
	gtk_widget_show (table2);

	ok_button = gtk_button_new_with_label("Ok");
	gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
			GTK_SIGNAL_FUNC (ok_click), (gpointer) "cool button");
	gtk_table_attach_defaults (GTK_TABLE(table2), ok_button, 2, 6, 1, 9);
	gtk_widget_show(ok_button);

	no_button = gtk_button_new_with_label("No");
	gtk_signal_connect (GTK_OBJECT (no_button), "clicked",
			GTK_SIGNAL_FUNC (no_clicked), (gpointer) "cool button");
	gtk_table_attach_defaults (GTK_TABLE(table2), no_button, 8, 12, 1, 9);
	gtk_widget_show(no_button);

	cancel_button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
			GTK_SIGNAL_FUNC (destroy_exit_dialog), (gpointer) "cool button");
	gtk_table_attach_defaults (GTK_TABLE(table2), cancel_button, 14, 18, 1, 9);
	gtk_widget_show(cancel_button);
	
	/* creating hbox and adding button */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(hbox), table2, FALSE, FALSE, 0);
	
	/* adding hbox into the table */
	gtk_table_attach(
		GTK_TABLE(table),
		hbox,
		0, 1, 1, 2,
		0, 0, 3, 3);
	
	/* creating the main frame, and add frame into it */
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(frame);
	
	/* Finally, don't forget to add the main frame into the dialog :) */
	gtk_container_add(GTK_CONTAINER(dialog), frame);
	
	gtk_widget_size_request(dialog, &requisition);
	gtk_widget_set_uposition(
		dialog,
		(gdk_screen_width() - requisition.width) / 2,
		(gdk_screen_height() - requisition.height) / 2);
	
	gtk_widget_show_all(dialog); 
//	return dialog;
}
