/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <regex.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/mtio.h>
#include <linux/cdrom.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <pthread.h>

#include "data.h"
#include "erreur.h"
#include "addisk.h"
#include "edit.h"
#include "waitbox.h"

#ifdef LIBC5
#define SIGUSR1 SIGSTKFLT
#define SIGUSR2 SIGUNUSED
#endif

GtkWidget *name_entry;

Folder temp_racine;
pthread_t thread2;
int fast_scan_error;


void finish_scan()
{
  void *ret;
  int i,trouve;
  if(pthread_join(thread2,&ret) == 28) printf("pouet\n");
  if(fast_scan_error == -1)
    {
      erreur_dialog(NULL, "Disk already mounted", "or bad argument in setup", "ERROR: Mount failed.");
      return;
    }
  if(fast_scan_error == -2)
    {
      erreur_dialog(NULL, "Can't umount disk", "Check if it's not in use", "Warning!");
    }

  change_name(&racine.folders[racine.nb_folders -1],fast_name);
  racine.folders[racine.nb_folders -1].type = 1;//is_a_disk;
  if (racine.nb_folders > 1)
    {
      racine.folders = (Folder*) realloc(racine.folders,(racine.nb_folders+1)*sizeof(Folder)); 
      i=racine.nb_folders -2;
      racine.folders[racine.nb_folders] = racine.folders[racine.nb_folders -1];
      trouve = 0;
      while(trouve == 0)
	{
	  if (i == -1)    
	    {
	      racine.folders[0] = racine.folders[racine.nb_folders];
	      trouve = 1;
	    } 
	  else if (strcmp(fast_name,racine.folders[i].name)<0)
	    {
	      racine.folders[i+1] = racine.folders[i];
	      i--;
	    }
	  else
	    {
	      racine.folders[i+1] = racine.folders[racine.nb_folders];
	      trouve = 1;
	    }
	}
      racine.folders = (Folder*) realloc(racine.folders,(racine.nb_folders)*sizeof(Folder));  
    }
  is_modified = 1;
  update_tree();
  close_waitbox();
}


int eject_disk()
{
  int status;
  char eject_path[200];

  sprintf(eject_path,"%s/share/gtktalog/eject",PREFIX);

  switch (fork()) {
  case 0: /* child */
    seteuid(getuid()); /* reduce likelyhood of security holes when running setuid */
    execl(eject_path, eject_path, mount_point, NULL);
    printf("unable to exec %s/eject",PREFIX);
    fflush(stdout);
    exit(1);
    break;
  case -1:
    fprintf(stderr, "unable to fork: \n");
    fflush(stdout);
    break;
  default: /* parent */
    wait(&status);
    if (WIFEXITED(status) == 0) {
      printf("Eject did not exit normally\n");
      fflush(stdout);
      return(-1);
    }
    if (WEXITSTATUS(status) != 0) {
      erreur_dialog(name_entry, "Umount failed", "Disk in use?", "ERROR !");
      return(-1);
    }
    return(1);
    break;
  }
  return(0);
}

int mount_disk()
{
  int status;
  
  switch (fork()) {
  case 0: /* child */
    seteuid(getuid()); /* reduce likelyhood of security holes when running setuid */
    execl(mount, mount, mount_point, NULL);
    printf("unable to exec /bin/mount of ");
    fflush(stdout);
    exit(1);
    break;
  case -1:
    fprintf(stderr, "unable to fork: \n");
    fflush(stdout);
    break;
  default: /* parent */
    wait(&status);
    if (WIFEXITED(status) == 0) {
      printf(" mount of did not exit normally\n");
      fflush(stdout);
      return(-1);
    }
    if (WEXITSTATUS(status) != 0) {
      printf("mount failed\n");
      fflush(stdout);
      return(-1);
    }
    return(1);
    break;
  }
  return(0);
}



int umount_disk()
{
  int status;
  
  switch (fork()) {
  case 0: /* child */
    seteuid(getuid()); /* reduce likelyhood of security holes when running setuid */
    execl(umount, umount, mount_point, NULL);
    fprintf(stderr, ": unable to exec /bin/umount of `\n");
    exit(1);
    break;
  case -1:
    fprintf(stderr, "unable to fork: \n");
    break;
  default: /* parent */
    wait(&status);
    if (WIFEXITED(status) == 0) {
      fprintf(stderr, ": unmount of ` did not exit normally\n");
      return(-1);
    }
    if (WEXITSTATUS(status) != 0) {
      fprintf(stderr, "unmount failed\n");
      return(-1);
    }
    break;
  }
  return(0);
}

void *start_fast_add_disk(void *arg/*GtkWidget *w, gpointer data*/)
{
  char temp[]="";
  
  if(mount_disk() == -1)
    {
      //erreur_dialog(name_entry, "Mount failed", "Bad parameters or CD already mounted", "ERROR !!!!");
      fast_scan_error = -1;
      kill(current_pid,SIGUSR1);
      if(waitbox_is_open == 1) kill(current_pid,SIGALRM);
      else waitbox_is_open = -1;
      pthread_exit(0);
    }
  
  //on commence a charger l'arborescence
  disk_path_size = strlen(mount_point);
  chdir(mount_point);
  if (racine.nb_folders == 0) racine.folders = (Folder*) malloc(sizeof(Folder));
  else racine.folders = (Folder*) realloc(racine.folders,(racine.nb_folders+1)*sizeof(Folder)); 
  init_folder(&racine.folders[racine.nb_folders],&racine,mount_point,0,0,0);
  create_folder_tree(&racine.folders[racine.nb_folders],temp);
  racine.nb_folders++;
  //fin de parcour de l'arborescence
  chdir(getenv("HOME"));

  if(umount_disk() == -1)
    {
      //erreur_dialog(name_entry, "Umount failed", "Disk in use?", "ERROR !");
      fast_scan_error = -2;
      kill(current_pid,SIGUSR1);
      if(waitbox_is_open == 1) kill(current_pid,SIGALRM);
      else waitbox_is_open = -1;
      pthread_exit(0);
    }
  eject_disk();
  is_modified = 1;
  
  while(waitbox_is_open == 0)
    {
      //j'attends! Faut ecrire plus vite le nom du disque aussi!
      // Pff! c'est boulets qui mettent deux heures a chercher 
      //leur touches obligent  faire de ces trucs!
    }

  kill(current_pid,SIGUSR1);

  pthread_exit(0);
  exit(0);
}


void get_name(GtkWidget *w, gpointer data)
{
  char *temp;

  temp = gtk_entry_get_text(GTK_ENTRY (name_entry));
  if(folder_exist_in(&racine,gtk_entry_get_text(GTK_ENTRY(name_entry)), data) == 1) return;
  free(fast_name);
  fast_name = (char *)malloc(strlen(temp +1)*sizeof(char));
  strcpy(fast_name,temp);
  gtk_widget_destroy(data);
  open_waitbox();
}






void fast_add_disk(GtkWidget *w, gpointer data)
{
  GtkWidget *name_window;
  GtkWidget *frame;
  GtkWidget *ok;
  GtkWidget *hbox;

  fast_scan_error = 0;
  if(pthread_create(&thread2, NULL,start_fast_add_disk ,name_window ) <0)
    {
      erreur_dialog(data, "Thread failed", "Check your number of threads.", "ERROR !");
      return;
    }
  
  signal(SIGUSR2,update_waitbox); 
  signal(SIGALRM,close_waitbox);

  name_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(name_window), TRUE, TRUE, FALSE);
  gtk_window_set_title(GTK_WINDOW(name_window),"Set disk name");
  gtk_container_border_width(GTK_CONTAINER(name_window),10);
  gtk_window_set_position (GTK_WINDOW (name_window), GTK_WIN_POS_MOUSE);
  gtk_widget_show (name_window);
  gtk_signal_connect (GTK_OBJECT (name_window), "delete_event",
			GTK_SIGNAL_FUNC (dumy_event), NULL);


  frame = gtk_frame_new ("Disk Label");
  gtk_container_add(GTK_CONTAINER(name_window),frame);
  gtk_widget_show (frame);
  
  hbox=gtk_hbox_new(FALSE,10);
  gtk_container_add(GTK_CONTAINER(frame),hbox);
  gtk_widget_show(hbox);

  name_entry = gtk_entry_new_with_max_length (50);
  if (fast_name == NULL) gtk_entry_set_text (GTK_ENTRY (name_entry), "");
  else  gtk_entry_set_text (GTK_ENTRY (name_entry), fast_name);
  gtk_entry_select_region (GTK_ENTRY (name_entry), 0, GTK_ENTRY(name_entry)->text_length);
  gtk_box_pack_start(GTK_BOX(hbox),name_entry,TRUE,TRUE,0);
  gtk_widget_show (name_entry);

  ok=gtk_button_new_with_label("   Ok   ");
  gtk_object_set_user_data(GTK_OBJECT(ok),name_window);
  GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
  gtk_window_set_default(GTK_WINDOW(name_window),ok);
  gtk_box_pack_start(GTK_BOX(hbox),ok,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(ok),"clicked",GTK_SIGNAL_FUNC(get_name),name_window);
  gtk_widget_show(ok); 

  chdir(getenv("HOME"));
  

  signal(SIGUSR1,finish_scan);
}

