/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/wait.h>
#include <fnmatch.h>

#include "data.h" 
#include "loadcat.h"
#include "erreur.h"

extern GtkWidget *filew;
char *information;
int infoSize;

typedef struct {
  unsigned char type;
  unsigned long int taille;
  unsigned long int date;
  unsigned char categorie;
  unsigned short int description;
} Donnees;

typedef struct {
  unsigned long int taille;
  unsigned long int date;
  unsigned char categorie;
  unsigned short int description;
} HoldDonnees;

Donnees data;
HoldDonnees holddata;
int j;
FILE *catalog;


void load_folder_tree(Folder *folder)
{
  char filename[100];
//  char filename2[100];
  char flag;
  unsigned long int i;
//  char a,b;
//  unsigned char fin;
 
  while((flag = getc(catalog)) != EOF)
    {
      switch(flag)
	{
	case 2:
//	  printf("Dans rep\n");
	  fflush(stdout);
	  
	  fgets(filename,100,catalog);
	  filename[strlen(filename)-1] = '\0'; //utile pour effacer le '\n' qui est a la fin!!

	  if (folder->nb_folders == 0) 
	    folder->folders = (Folder*) malloc(sizeof(Folder));
	  else
	    folder->folders = (Folder*) realloc(folder->folders,(folder->nb_folders+1)*sizeof(Folder));
	  fread(&data,sizeof(Donnees),1,catalog);
	  if((data.type>>7) == 1)
	    {
	      fread(&i,sizeof(unsigned long int),1,catalog);
	      free(information);
	      information = (char *)malloc((i+1)*sizeof(char));
	      fread(information,i*sizeof(char),1,catalog);
	      information[i] = '\0';
	      add_folder(&folder->folders[folder->nb_folders],folder, filename,information,data.type,data.taille, data.date,data.categorie,data.description);
	    }
	  else add_folder(&folder->folders[folder->nb_folders],folder, filename,"",data.type,data.taille, data.date,data.categorie,data.description);
	  folder->nb_folders++;
	  if ((j == 1)&&(is_link(&folder->folders[folder->nb_folders-1]) == 1))
	    {
	      fgets(filename,100,catalog); 
	      filename[strlen(filename)-1] = '\0';
	      
	      folder->folders[folder->nb_folders-1].folders = (Folder *)malloc(sizeof(Folder));
	      folder->folders[folder->nb_folders-1].folders[0].name = (char *)malloc((strlen(filename)+1)*sizeof(char));
	      strcpy(folder->folders[folder->nb_folders-1].folders[0].name,filename);
	    }
	  else
	    {
	      j = 1;
	      load_folder_tree(&folder->folders[folder->nb_folders-1]);
	    }
//	  printf("hors rep\n");
	  fflush(stdout); 
	  break;
	case 3:
//	  printf("Dans fichier\n");
	  fflush(stdout);

	  fgets(filename,100,catalog);
	  filename[strlen(filename)-1] = '\0';
	  if (folder->nb_files == 0)
	    folder->files = (Folder*) malloc(sizeof(Folder));
	  else
	    folder->files = (Folder*) realloc (folder->files,(folder->nb_files+1)*sizeof(Folder));
	  fread(&data,sizeof(Donnees),1,catalog);
	  if((data.type>>7) == 1)
	    {
	      fread(&i,sizeof(unsigned long int),1,catalog);
	      free(information);
	      information = (char *)malloc((i+1)*sizeof(char));
	      fread(information,i*sizeof(char),1,catalog);
	      information[i] = '\0';
	      add_folder(&folder->files[folder->nb_files],folder, filename,information,data.type,data.taille, data.date,data.categorie,data.description);
	    }
	  else  add_folder(&folder->files[folder->nb_files],folder, filename,"",data.type,data.taille, data.date,data.categorie,data.description);	   
	  folder->nb_files++;
//	  printf("hors fichier\n");
	  fflush(stdout);
	  break;
	case 12: 
//	  printf("Deb sortie rep\n");
	  fflush(stdout);
	  fgets(filename,100,catalog);// pour passer le '\n'
//	  printf("fin sortie rep\n");
	  fflush(stdout);
	  return;
	default: /*printf("rien trouv! ca chie! %d \n",flag)*/;
	}
    }
}




void load_hold_folder_tree(Folder *folder)
{
  char filename[100];
  char flag;
  unsigned char b;
 
  while((flag = getc(catalog)) != EOF)
    {
      switch(flag)
	{
	case 2:
	  fgets(filename,100,catalog);
	  filename[strlen(filename)-1] = '\0'; //utile pour effacer le '\n' qui est a la fin!!
	  if (folder->nb_folders == 0) 
	    folder->folders = (Folder*) malloc(sizeof(Folder));
	  else
	    folder->folders = (Folder*) realloc(folder->folders,(folder->nb_folders+1)*sizeof(Folder));
	  fread(&holddata,sizeof(HoldDonnees),1,catalog);
	  b = holddata.taille>>30;
	  if (b == 0) b = 4;
	  add_folder(&folder->folders[folder->nb_folders],folder, filename,"",b,holddata.taille, holddata.date,holddata.categorie,holddata.description);
	  folder->nb_folders++;
	  if ((j == 1)&&(is_link(&folder->folders[folder->nb_folders-1]) == 1))
	    {
	      fgets(filename,100,catalog); 
	      filename[strlen(filename)-1] = '\0';
	      folder->folders[folder->nb_folders-1].folders = (Folder *)malloc(sizeof(Folder));
	      folder->folders[folder->nb_folders-1].folders[0].name = (char *)malloc((strlen(filename)+1)*sizeof(char));
	      strcpy(folder->folders[folder->nb_folders-1].folders[0].name,filename);
	    }
	  else
	    {
	      j = 1;
	      load_hold_folder_tree(&folder->folders[folder->nb_folders-1]);
	    }
	  break;
	case 3:
	  fgets(filename,100,catalog);
	  filename[strlen(filename)-1] = '\0';
	  if (folder->nb_files == 0)
	    folder->files = (Folder*) malloc(sizeof(Folder));
	  else
	    folder->files = (Folder*) realloc (folder->files,(folder->nb_files+1)*sizeof(Folder));
	  fread(&holddata,sizeof(HoldDonnees),1,catalog);
	  b = holddata.taille>>30;
	  add_folder(&folder->files[folder->nb_files],folder, filename,"",b,holddata.taille, holddata.date,holddata.categorie,holddata.description);	   
	  folder->nb_files++;
	  break;
	case 12: 
	  fgets(filename,100,catalog);// pour passer le '\n'
	  return;
	default: /*printf("rien trouv! ca chie! %d \n",flag)*/;
	}
    }
}




/* j'ai cree cette fonction, car ca marche pas dans load_folder_tree*/
/* si quelqu'un sait pourquoi, me mailer a: gtktalog@caramail.com   */
void enable_parents(Folder *folder)
{
  int i;
  for(i=0;i<folder->nb_folders;i++)
    {
      folder->folders[i].parent = folder;
      enable_parents(&folder->folders[i]);
    }
  for(i=0;i<folder->nb_files;i++)
    {
      folder->files[i].parent = folder;
    }

}




static gint32 load_compressed_image (char *filename)
{
  int pid;
  int status;


  if ((pid = fork()) < 0)
    {
      g_message ("fork failed: %s\n", g_strerror(errno));
      erreur_dialog(filew,"fork failed:",g_strerror(errno),"ERROR!"); 
      return -1;
    }
  else if (pid == 0)  /* child process */
    {
      FILE* f;
       if (!(f = fopen("/tmp/gtktalogtmpfile","w+")))
	 {
	   g_message("gz: fopen failed: %s\n", g_strerror(errno));
	   erreur_dialog(filew,"fopen failed:",g_strerror(errno),"ERROR!");
	   _exit(127);
	 }

      if (-1 == dup2(fileno(f),fileno(stdout)))
	g_message ("gz: dup2 failed: %s\n", g_strerror(errno));

      if (fnmatch("*.gz",filename,0) == 0) execlp ("gzip", "gzip", "-cfd", filename, NULL);
      if (fnmatch("*.bz2",filename,0) == 0) execlp ("bzip2", "bzip2", "-cfd", filename, NULL);	  
      if (fnmatch("*.gz",filename,0) == 0)
	{
	  g_message ("gzip: exec failed: %s\n", g_strerror(errno));
	  erreur_dialog(filew,"gzip: exec failed:",g_strerror(errno),"ERROR!");
	}
      if (fnmatch("*.bz2",filename,0) == 0)
	{
	  g_message ("bzip: exec failed:  %s\n", g_strerror(errno));
	  erreur_dialog(filew,"bzip2: exec failed:",g_strerror(errno),"ERROR!");
	}
      _exit(127);
    }
  else  /* parent process */
    {
      waitpid (pid, &status, 0);

      if (!WIFEXITED(status) ||
	  WEXITSTATUS(status) != 0)
	{
	  if (fnmatch("*.gz",filename,0) == 0)
	    {
	      g_message ("gz: gzip exited abnormally on file %s\n","/tmp/gtktalogtmpfile" );
	      erreur_dialog(filew,"gz: gzip exited abnormally on file","/tmp/gtktalogtmpfile","ERROR!");
	    }
	  if (fnmatch("*.bz2",filename,0) == 0)
	    {
	      g_message ("bz2: bzip2 exited abnormally on file %s\n","/tmp/gtktalogtmpfile" );
	      erreur_dialog(filew,"bz2: bzip2 exited abnormally on file","/tmp/gtktalogtmpfile","ERROR!");
	    }
	  return -1;
	}
    }
  return 0;
}





int load_cat_from_file(char *filename)
{
  char filename2[200];
  char data2[500];
  int fin = 0;
  char flag;

  j = 0;
  
  information = (char *)malloc(sizeof(char));
   if ((fnmatch("*.gz",filename,0) == 0)||(fnmatch("*.bz2",filename,0) == 0))
    {
      if (load_compressed_image(filename) == 0)
	{
	  if ((catalog = fopen("/tmp/gtktalogtmpfile","r")) == NULL)
	    {
	      return(-1);
	    }
	}
    }
  else if((catalog = fopen(filename,"r")) == NULL)
    {
      return(-1);
    }


  fgets(filename2,100,catalog);
  filename2[strlen(filename2)-1] = '\0';
  if ((strcmp(filename2,"gtktalog") != 0)&&(strcmp(filename2,"gtktalog2") != 0))
    {
      fclose(catalog);
      return(-1);
    }
  while(fin == 0)
    {
      flag = getc(catalog);
      switch(flag)
	{  
	case 0:
	  fgets(data2,200,catalog);
	  data2[strlen(data2)-1] = '\0';
	  categories = (char **)realloc(categories,(nb_categories+1)*sizeof(char *));
	  categories[nb_categories] = (char *)malloc((strlen(data2)+1)*sizeof(char));
	  strcpy(categories[nb_categories],data2);
	  nb_categories++;
	  break;
	case 1:
	  fgets(data2,200,catalog);
	  data2[strlen(data2)-1] = '\0';
	  descriptions = (char **)realloc(descriptions,(nb_descriptions+1)*sizeof(char *));
	  descriptions[nb_descriptions] = (char *)malloc((strlen(data2)+1)*sizeof(char));
	  strcpy(descriptions[nb_descriptions],data2);
	  nb_descriptions++;
	  break;
	case 10:
	  fin =1;
	  break;
	}	  
    }
//  add_foldername(&racine, filename2);
  if (strcmp(filename2,"gtktalog2") == 0) 
    {
      load_folder_tree(&racine);
      fclose(catalog);
      enable_parents(&racine);
      is_modified = 0;
      return(0); 
    }
  else
    {
      load_hold_folder_tree(&racine);
      fclose(catalog);
      enable_parents(&racine);
      is_modified = 1;
      erreur_dialog(NULL,"Catalog converted to DB2","Save it to enable DB2","GTKtalog DataBase 1 found");
      return(0);
    }
}
