/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* In this file, the administration of breakpoints is managed. */

/* types ====================================================================*/

typedef struct /* associates a rule system with a name */
{
  rule_sys_t *rule_sys;
  string_t name; /* name of the above rule system */
} rule_sys_name_t;

/* functions ================================================================*/

extern int_t at_breakpoint (rule_sys_t *rule_sys, int_t instruction);
/* Return breakpoint number if <instruction> in <rule_sys> hits a breakpoint; 
 * return 0 else. */

extern void init_breakpoints (int_t num_rule_sys, rule_sys_name_t rule_sys[]);
/* Initialise this module. Pass the number of rule systems in <num_rule_sys> 
 * and their names in <rule_sys>. */

extern void terminate_breakpoints (void); 
/* Terminate this module. */

/* commands =================================================================*/

extern command_t delete_command;
/* Delete a breakpoint. */

extern command_t break_command;
/* Define a breakpoint. */

extern command_t list_command;
/* List breakpoints. */

/* end of file ==============================================================*/
