/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* This module contains structures and functions for the run-time lexicon. */

/* functions ================================================================*/

extern void init_lexicon (string_t file_name);
/* Initialise this module. Read lexicon from file <file_name>. */

extern void terminate_lexicon (void);
/* Terminate this module. */

extern void search_for_prefix (string_t string);
/* Search lexicon for prefixes of <string> in increasing length. 
 * The results are obtained by calling "get_next_prefix". */

extern bool_t get_next_prefix (string_t *string_ptr, value_t *cat);
/* Get the next lexicon entry that is a prefix of <string>. 
 * Return FALSE iff no more entries exist.
 * If another entry exists, set <*string_ptr> to the remainder of <string>
 * and <*cat> to the category assigned to the lexicon entry.
 * <string> must have been set by "search_for_prefix". */

/* end of file ==============================================================*/
