/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** Code for executing Set/GetConnect/StmtOption.
*/


#include "myodbc.h"

static SQLRETURN set_stmt_option(DBC *dbc,
				 STMT_OPTIONS *option,
				 SQLUSMALLINT fOption,
				 SQLUINTEGER vParam);
static SQLRETURN get_stmt_option(DBC FAR *dbc,STMT_OPTIONS *options,
				 SQLUSMALLINT fOption,SQLPOINTER vParam);


SQLRETURN SQL_API SQLSetConnectOption(SQLHDBC hdbc, SQLUSMALLINT fOption,
				      SQLUINTEGER  vParam)
{
  DBC *dbc=(DBC FAR*) hdbc;
  DBUG_ENTER("SQLSetConnectOption");
  DBUG_PRINT("enter",("Option: %d  Param: %ld",fOption,(ulong) vParam));
  switch (fOption) {
  case SQL_ACCESS_MODE:
    DBUG_PRINT("info",("SQL_ACCESS_MODE %ld ignored",vParam));
    break;
  case SQL_AUTOCOMMIT:
    if (vParam != SQL_AUTOCOMMIT_ON)
      DBUG_RETURN(set_error(dbc,"S1C00","MySQL can't use transactions",4000));
    break;
  case SQL_CURRENT_QUALIFIER:
  {
    if (mysql_select_db(&dbc->mysql,(char*) vParam))
    {
      strmov(dbc->sqlstate,"S1000");
      DBUG_RETURN(SQL_ERROR);
    }
    my_free((gptr) dbc->database,MYF(0));
    dbc->database=my_strdup((char*) vParam,MYF(MY_WME));
    break;
  }
  case SQL_LOGIN_TIMEOUT:
    dbc->login_timeout=(ulong) vParam;
    break;
  case SQL_ODBC_CURSORS:
  case SQL_OPT_TRACE:
  case SQL_OPT_TRACEFILE:
  case SQL_QUIET_MODE:
  case SQL_TRANSLATE_DLL:
  case SQL_TRANSLATE_OPTION:
    DBUG_PRINT("error",("This shouldn't happen"));
    break;
  case SQL_PACKET_SIZE:
    DBUG_PRINT("info",("SQL_PACKET_SIZE %ld ignored",vParam));
    break;
  case SQL_TXN_ISOLATION:
    DBUG_PRINT("info",("SQL_TXN_ISOLATION %ld ignored",vParam));
    break;
  case SQL_QUERY_TIMEOUT:
  case SQL_MAX_ROWS:
  case SQL_NOSCAN:
  case SQL_MAX_LENGTH:
  case SQL_ASYNC_ENABLE:
  case SQL_BIND_TYPE:
  case SQL_CURSOR_TYPE:
  case SQL_CONCURRENCY:
  case SQL_KEYSET_SIZE:
  case SQL_ROWSET_SIZE:
  case SQL_SIMULATE_CURSOR:
  case SQL_RETRIEVE_DATA:
  case SQL_USE_BOOKMARKS:
    DBUG_RETURN(set_stmt_option(dbc,&dbc->stmt_options,fOption,vParam));
  default:
#ifdef REAL
    DBUG_RETURN(set_error(hdbc,"S1C00",
 			  "Unknown option used with SQLSetConnectOption",
 			  4000));
#else
    DBUG_PRINT("error", ("Unknown option %d to SQLSetConnectOption (but returned SQL_SUCCESS)", fOption));
#endif
  }
  DBUG_RETURN(SQL_SUCCESS);
}


SQLRETURN SQL_API SQLGetConnectOption(SQLHDBC hdbc,SQLUSMALLINT fOption,SQLPOINTER vParam)
{
  DBC *dbc=(DBC FAR*) hdbc;
  DBUG_ENTER("SQLGetConnectOption");
  DBUG_PRINT("enter",("Option: %d  Param: %ld",fOption,(ulong) vParam));

 switch (fOption) {
  case SQL_ACCESS_MODE:
    *((long*) vParam)= SQL_MODE_READ_WRITE;
    break;
  case SQL_AUTOCOMMIT:
    *((long*) vParam)= SQL_AUTOCOMMIT_ON;
    break;
  case SQL_CURRENT_QUALIFIER:
    DBUG_RETURN(copy_result(dbc,(uchar FAR*) vParam,
			    SQL_MAX_OPTION_STRING_LENGTH,
			    (SQLSMALLINT FAR *) 0, dbc->database));
  case SQL_LOGIN_TIMEOUT:
    *((long*) vParam)= dbc->login_timeout;
    break;
  case SQL_ODBC_CURSORS:
  case SQL_OPT_TRACE:
  case SQL_OPT_TRACEFILE:
  case SQL_QUIET_MODE:
  case SQL_TRANSLATE_DLL:
  case SQL_TRANSLATE_OPTION:
    DBUG_RETURN(set_error(dbc,"S1C00",
			  "Impossible option used with SQLGetConnectOption",
			  4000));
  case SQL_PACKET_SIZE:
    *((long*) vParam)= dbc->mysql.net.max_packet;
    break;
  case SQL_TXN_ISOLATION:
    *((long*) vParam)= SQL_TXN_READ_UNCOMMITTED;
    break;
  case SQL_QUERY_TIMEOUT:
  case SQL_MAX_ROWS:
  case SQL_NOSCAN:
  case SQL_MAX_LENGTH:
  case SQL_ASYNC_ENABLE:
  case SQL_BIND_TYPE:
  case SQL_CURSOR_TYPE:
  case SQL_CONCURRENCY:
  case SQL_KEYSET_SIZE:
  case SQL_ROWSET_SIZE:
  case SQL_SIMULATE_CURSOR:
  case SQL_RETRIEVE_DATA:
  case SQL_USE_BOOKMARKS:
    DBUG_RETURN(get_stmt_option(dbc,&dbc->stmt_options,fOption,vParam));

  default:
    DBUG_PRINT("error", ("Unknown option %d to SQLSetConnectOption (but returned SQL_SUCCESS)", fOption));
    break;
  }
  DBUG_RETURN(SQL_SUCCESS);
}


SQLRETURN SQL_API SQLSetStmtOption(SQLHSTMT hstmt,SQLUSMALLINT fOption,SQLUINTEGER vParam)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLSetStmtOption");
  DBUG_RETURN(set_stmt_option(stmt->dbc,&stmt->stmt_options,fOption,vParam));
}

static SQLRETURN set_stmt_option(DBC *dbc,STMT_OPTIONS *option,SQLUSMALLINT fOption,
			       SQLUINTEGER vParam)
{
  DBUG_ENTER("set_stmt_option");
  DBUG_PRINT("enter",("Option: %d  Param: %ld",fOption,(ulong) vParam));

  switch (fOption) {
  case SQL_ASYNC_ENABLE:
  case SQL_BIND_TYPE:
    option->bind_type=(ulong) vParam;
    break;
  case SQL_CONCURRENCY:			/* Lie for these */
  case SQL_KEYSET_SIZE:
  case SQL_NOSCAN:
  case SQL_QUERY_TIMEOUT:
  case SQL_RETRIEVE_DATA:
    DBUG_PRINT("info",("Option value is ignored"));
    break;
  case SQL_CURSOR_TYPE:
    if ((SQLUINTEGER) vParam == SQL_CURSOR_FORWARD_ONLY ||
	(SQLUINTEGER) vParam == SQL_CURSOR_STATIC)
      option->cursor_type=(uint) vParam;
    else
    {
      option->cursor_type=SQL_CURSOR_STATIC;
      set_error(dbc,"01S02", "Using static cursors instead of requested type",
		4000);
      DBUG_RETURN(SQL_SUCCESS_WITH_INFO);
    }
    break;
  case SQL_MAX_LENGTH:
    option->max_length=(ulong) vParam;
    break;
  case SQL_MAX_ROWS:
    option->max_rows=(ulong) vParam;
    break;
  case SQL_ROWSET_SIZE:
    option->rows_in_set= (ulong) vParam;
    break;
  case SQL_SIMULATE_CURSOR:
  case SQL_USE_BOOKMARKS:
  default:
    DBUG_RETURN(set_error(dbc,"S1COO",
			  "MySQL doesn't support this SetStmtOption",4000));
  }
  DBUG_RETURN(SQL_SUCCESS);
}


SQLRETURN SQL_API SQLGetStmtOption(SQLHSTMT hstmt,SQLUSMALLINT fOption,SQLPOINTER vParam)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLGetStmtOption");
  switch (fOption) {
  case SQL_GET_BOOKMARK:
    DBUG_RETURN(set_error(stmt->dbc,"S1C00","This doesn't work yet",4000));
  case SQL_ROW_NUMBER:
    *((long*) vParam)=stmt->current_row+1;
    break;
  default:
    DBUG_RETURN(get_stmt_option(stmt->dbc, &stmt->stmt_options,fOption,
				vParam));
  }
  DBUG_RETURN(SQL_SUCCESS);
}


static SQLRETURN get_stmt_option(DBC FAR *dbc,STMT_OPTIONS *options,
			       SQLUSMALLINT fOption,SQLPOINTER vParam)
{
  DBUG_ENTER("get_stmt_options");
  DBUG_PRINT("enter",("Option: %d",fOption));

  switch (fOption) {
  case SQL_ASYNC_ENABLE:
    *((ulong*) vParam)=SQL_ASYNC_ENABLE_OFF;
    break;
  case SQL_BIND_TYPE:
    *((long*) vParam)= options->bind_type;
    break;
  case SQL_CONCURRENCY:
    *((long*) vParam)= SQL_CONCUR_ROWVER;	/* Anything goes */
    break;
  case SQL_KEYSET_SIZE:				/* Can't be that wrong */
  case SQL_QUERY_TIMEOUT:
    *((long*) vParam)=0L;
    break;
  case SQL_NOSCAN:
    *((long*) vParam)=SQL_NOSCAN_ON;
    break;
  case SQL_RETRIEVE_DATA:
    *((long*) vParam)=SQL_RD_ON;
    break;
  case SQL_CURSOR_TYPE:
    *((long*) vParam)=options->cursor_type;
    DBUG_PRINT("info",("This may be wrong:  Change your application to use ODBC Manger cursors or add 128 or 256 to your Option flag!"));
    break;
  case SQL_MAX_LENGTH:
    *((long*) vParam)= options->max_length;
    break;
  case SQL_MAX_ROWS:
    *((long*) vParam)= options->max_rows;
    break;
  case SQL_ROWSET_SIZE:
    *((ulong*) vParam)= options->rows_in_set;
    break;
  case SQL_SIMULATE_CURSOR:
    *((long*) vParam)= SQL_SC_NON_UNIQUE;
    break;
  case SQL_USE_BOOKMARKS:
    *((long*) vParam)=SQL_UB_OFF;
    break;
  default:
    DBUG_RETURN(set_error(dbc,"S1C00","This doesn't work yet",4000));
    break;
  }
 DBUG_RETURN(SQL_SUCCESS);
}
