#! /usr/bin/perl -w
#                              -*- Mode: Perl -*- 
# Virtual.pm --- 
# Author           : Manoj Srivastava ( srivasta@tiamat.datasync.com ) 
# Created On       : Thu Feb 20 01:14:07 1997
# Created On Node  : tiamat.datasync.com
# Last Modified By : Manoj Srivastava
# Last Modified On : Sun Mar  8 15:50:36 1998
# Last Machine Used: tiamat.datasync.com
# Update Count     : 15
# Status           : Unknown, Use with caution!
# HISTORY          : 
# Description      : 
# 
# 

=head1 NAME

  Debian::Package::Virtual - List of Virtual Packages

 
=cut

=head1 SYNOPSIS

  use Debian::Package::Virtual;
  # Initialize the Virtual package list, taking the install time
  # default list
  $pkg = Debian::Package::Virtual->new();
  # Print it back again
  $pkg->print();

  # Exercise new and print
  Debian::Package::Virtual->test();

=cut

package Debian::Package::Virtual;
 
use strict;
use Carp;
require 5.001;

=head1 DESCRIPTION


This module implements a Virtual package list object. 

=cut

=head2 new

This is the constructor for the package. It takes a optional named
argument 'Virtual Packages', which is a space separated list of
virtual package names.

=cut

my $Default_pkgs = "X11R5 X11R6 awk c-shell compress emacs gs gs_both "  .
  " gs_svga gs_x httpd imap-client imap-server inews info-browser " .
  " kernel-headers kernel-image kernel-source libc.so.4 mail-reader " .
  " mail-transport-agent news-reader news-transport-system pdf-preview " .
  " pdf-viewer pgp postscript-preview postscript-viewer sgmls www-browser " .
  " xR5shlib xR6shlib xlibraries xpm xpmR6 xserver";

sub new {
  my $this = shift;
  my %params = @_;
  my $class = ref($this) || $this;
  my $self = {};
  my $pkgs = $params{'Virtual Packages'} ? $params{'Virtual Packages'}
  : $Default_pkgs;
  
  bless $self => $class;
  for (split ' ', $pkgs) {
    $self->{$_} = $_;
  }
  return $self;
}

=head2 print

This method takes the Virtual Package List and prints it out.

=cut
 
sub print {
  my $self = shift;
  for (sort keys %$self) {
    next if /^\s+_/og;
    print "$_ \n";
  }
}


=head2 test


This method exercises new and print.

=cut
 

sub test {
  my $self = shift;
  my $var = Debian::Package::Virtual->new();

  $var->print();
}

=head2


As a bonus, you may execute this file, and it will do a test run for
you. .

=cut


{ # Execute simple test if run as a script
  package main; no strict;
  eval join('',<main::DATA>) || die "$@ $main::DATA" unless caller();
}


1;

__END__

# Test code. Execute this module as a CGI script.

use Debian::Package::Virtual;
Debian::Package::Virtual->test();
1;

#end
