/*
 * Copyright (C) 1999  Ross Combs (rocombs@cs.nmsu.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include "config.h"
#ifndef HAVE_STRTOUL

#include "setup.h"
#include "strtoul.h"


extern unsigned long strtoul(char const * str, char * * endptr, int base)
{
    unsigned int  pos;
    unsigned int  i;
    unsigned long val;
    
    if (!str)
	return 0;
    if (base!=2 && base!=8 && base!=10 && base!=16) /* sorry, not complete emulation */
	return 0;
    
    for (pos=0; str[pos]==' ' || str[pos]=='\t'; pos++);
    if (str[pos]=='-')
	return 0; /* sorry, not complete emulation */
    if (str[pos]=='+')
        pos++;
    if (base==16 && str[pos]=='0')
	if (str[pos+1]=='x')
	    pos += 2; /* skip 0x prefix */
    
    val = 0;
    for (i=pos; str[i]!='\0'; i++)
    {
        val *= base;
	
	if (str[i]=='0')
	    continue;
	if (str[i]=='1')
	{
	    val += 1;
	    continue;
	}
	if (base<=2)
	    break;
	
	if (str[i]=='2')
	{
	    val += 2;
	    continue;
	}
	if (str[i]=='3')
	{
	    val += 3;
	    continue;
	}
	if (str[i]=='4')
	{
	    val += 4;
	    continue;
	}
	if (str[i]=='5')
	{
	    val += 5;
	    continue;
	}
	if (str[i]=='6')
	{
	    val += 6;
	    continue;
	}
	if (str[i]=='7')
	{
	    val += 7;
	    continue;
	}
	if (base<=8)
	    break;
	
	if (str[i]=='8')
	{
	    val += 8;
	    continue;
	}
	if (str[i]=='9')
	{
	    val += 9;
	    continue;
	}
	if (base<=10)
	    break;
	
	if (str[i]=='a' || str[i]=='A')
	{
	    val += 10;
	    continue;
	}
	if (str[i]=='b' || str[i]=='B')
	{
	    val += 11;
	    continue;
	}
	if (str[i]=='c' || str[i]=='C')
	{
	    val += 12;
	    continue;
	}
	if (str[i]=='d' || str[i]=='D')
	{
	    val += 13;
	    continue;
	}
	if (str[i]=='e' || str[i]=='E')
	{
	    val += 14;
	    continue;
	}
	if (str[i]=='f' || str[i]=='F')
	{
	    val += 15;
	    continue;
	}
	break;
    }
    
    if (endptr)
	*endptr = (void *)&str[i]; /* avoid warning */
    
    return val;
}

#endif
