// Header file for FTP-related functions

#ifndef DAEMON_FTP_H
#define DAEMON_FTP_H

#include "global.h"
#include "sockets.h"

BOOL FtpStartGettingFile(FileInfo *file);
BOOL FtpStartPuttingFile(FileInfo *file);
BOOL FtpRecursiveGet(FileInfo *file, const char *root_path,
                     const char *extra_path);
BOOL FtpSingleGet(FileInfo *file);
BOOL FtpRecursivePut(FileInfo *file, const char *root_path,
                     const char *extra_path);
BOOL FtpSinglePut(FileInfo *file);

int GetFileSize(FileInfo *file);
BOOL ListFile(FileInfo *file, const char *path, char *buffer, int buf_size);

BOOL LogIn(SockInfo *sock, const char *user, const char *pass, char *activity);
BOOL SetType(SockInfo *sock, char type);
BOOL List(SockInfo *sock, const char *path, BOOL verbose);
BOOL Restore(SockInfo *sock, int position);
BOOL Get(SockInfo *sock, const char *path);
BOOL Put(SockInfo *sock, const char *path, BOOL append);

#endif
