/* Please read the file README !
   This is Fefe's finger daemon, the current version is available from
     ftp://ftp.fu-berlin.de/pub/unix/security/ffingerd/
   There is a home page for this finger daemon, too, the URL is
     http://www.fefe.de/ffingerd/ */

#include <config.h>

#include <stdio.h>

#ifndef HAVE_STRCHR
# ifdef HAVE_INDEX
#  define strchr index
# else
error "No string processing available. Get a Real OS[TM]"
# endif
#endif

#ifdef STDC_HEADERS
# include <string.h>
#else
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# else
char *strchr ();
# endif
#endif
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
# include <sys/types.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#include <pwd.h>
#include <netdb.h>
#include <sys/stat.h>

#ifdef HAVE_SYSLOG_H
# include <syslog.h>
#else
# ifdef HAVE_SYS_SYSLOG_H
#  include <sys/syslog.h>
# else
#  ifdef HAVE_SYSLOG
void openlog();
void syslog();
void closelog();
#  else
#   define NO_SYSLOG
#  endif 
# endif
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#ifdef HAVE_SYS_ERRNO_H
#include <sys/errno.h>
#endif

#ifndef PATH_MAX
#define PATH_MAX 256
#endif

#ifdef __STDC__
void dump_file(char *filename,char *found_message,char *not_found_message) {
#else
void dump_file(filename, found_message, not_found_message) 
  char *filename;
  char *found_message;
  char *not_found_message;
{
#endif
  FILE *file;
  char line[256];
  struct stat stat_buf;

  if (lstat(filename,&stat_buf)) {
    puts(not_found_message);
  } else {
    if (S_ISLNK(stat_buf.st_mode)) {
#ifndef NO_SYSLOG
      char message[512],linkdest[255];
      int i;
      if ((i=readlink(filename,linkdest,254)) != -1) {
	linkdest[i]=0;
      } else {
	linkdest[0]='\0';
      }
      sprintf(message,"file \"%.200s\" is a symbolic link to \"%.200s\"!\n",filename,linkdest);
      syslog(LOG_FACILITY,"%s",message);
#endif
      puts(not_found_message);
    } else if (S_ISREG(stat_buf.st_mode)) {
      puts(found_message);
      if ((file=fopen(filename,"r"))) {
	for (;;) {
	  if (fgets(line,255,file)) {
	    fputs(line,stdout);
	  } else {
	    break;
	  }
	}
	fclose(file);
      }
    } else {
      puts(not_found_message);
    }
  }
}

#ifdef NEXT
#define S_ISREG(x) (x & S_IFREG)
#endif

#ifdef __STDC__
void dump_user(struct passwd *pwd,unsigned char *remote) {
#else
void dump_user(pwd,remote)
struct passwd *pwd;
unsigned char *remote;
{
#endif
  char filename[PATH_MAX+20];
  struct stat stat_buf;

  setgid(pwd->pw_gid);
  setuid(pwd->pw_uid);
  sprintf(filename,"%.200s/.nofinger",pwd->pw_dir);
  if (lstat(filename,&stat_buf) && (errno==ENOENT)) {
#ifndef NO_SYSLOG
#ifdef FASCIST_LOGGING
    char message[512];
    sprintf(message,"finger \"%.200s\" from %.200s\n",pwd->pw_name,remote);
    syslog(LOG_FACILITY,"%s",message);
#endif
#endif
    sprintf(filename,"%.200s",pwd->pw_gecos);
    if (strchr(filename,',')) { *(char *)strchr(filename,',')=0; }
    printf("Login: %-30s  Name: %-40s\n",pwd->pw_name,filename);
    sprintf(filename,"%.200s/.project",pwd->pw_dir);
    dump_file(filename,"Project:","No project.");
    sprintf(filename,"%.200s/.plan",pwd->pw_dir);
    dump_file(filename,"Plan:","No plan.");
    sprintf(filename,"%.200s/.pubkey",pwd->pw_dir);
    dump_file(filename,"Public key:","No public key.");
  } else {
    char message[512];
    puts("That user does not want to be fingered.");
#ifndef NO_SYSLOG
    sprintf(message,"attempt to finger \"%.200s\" from %.200s\n",pwd->pw_name,remote);
    syslog(LOG_FACILITY,"%s",message);
#endif
  }
}

int main()
{
  char message[512];
  unsigned char query[256];
  unsigned char *qptr;
  struct sockaddr_in name;
  int len;
  unsigned long remote;
  char Remote[256];
  char *Remote_IP;
  struct passwd *pwd;
  struct hostent *host;

  openlog("ffingerd",LOG_PID,LOG_DAEMON);
  len=sizeof(name);
  if (getpeername(0, (struct sockaddr *)&name,&len) == -1) {
/*    perror("getpeername"); */
    if (errno==ENOTSOCK) {
      remote=0x7f000001;
    } else {
      syslog(LOG_ERR,"getpeername: %m");
      closelog();
      exit(0);
    }
  } else {
    if (name.sin_family != AF_INET) {
      syslog(LOG_ERR,"Connection not from INET domain ?!");
      closelog();
      exit(0);
    }
    remote=ntohl(name.sin_addr.s_addr);
#ifdef HAVE_INET_NTOA
    Remote_IP=inet_ntoa(name.sin_addr);
#else
    Remote_IP=malloc(40);
    sprintf(Remote_IP,"%ld.%ld.%ld.%ld",
            remote>>24 & 255,remote>>16 & 255,
	    remote>>8 & 255,remote & 255);
#endif
    if ((host=gethostbyaddr((char *)&name.sin_addr,sizeof(struct in_addr),AF_INET))) {
      sprintf(Remote,"%.200s [%.40s]",host->h_name,Remote_IP);
    } else {
/*      herror("gethostbyaddr");*/
      sprintf(Remote,"%.40s [%.40s]",Remote_IP,Remote_IP);
    }
  }
  if (!fgets(query,255,stdin)) exit(1);
  for (len = 0; query[len]; len++) {
    if (query[len] == '\r' || query[len] == '\n') {
      query[len] = '\0';
      break;
    }
    if (query[len] == '@') {
#ifndef NO_SYSLOG
      sprintf(message,"indirect finger attempt at %.200s from %.200s\n",query,Remote);
      syslog(LOG_FACILITY,"%s",message);
      closelog();
#endif
      puts("Sorry, we do not support indirect finger queries.");
      exit(0);
    }
  }
  qptr=query;
  if (*qptr==' ') qptr++;
  if (*qptr=='/' && (*(qptr+1)=='W' || *(qptr+1)=='w')) qptr+=2;
  if (*qptr==' ') qptr++;
  if (*qptr==0) {
#ifndef NO_SYSLOG
    sprintf(message,"empty finger attempt from %s\n",Remote);
    syslog(LOG_FACILITY,"%s",message);
    closelog();
#endif
    puts("Sorry, we do not support empty finger queries.");
    exit(0);
  }
  if ((pwd=getpwnam(qptr))) {
    dump_user(pwd,(unsigned char*)Remote);
  } else {
    sprintf(message,"attempt to finger \"%.200s\" from %.200s\n",qptr,Remote);
    syslog(LOG_FACILITY,"%s",message);
    puts("That user does not want to be fingered.");
  }
  closelog();
  return 0;
}
