/*****************************************************************************/
/*  rename_dialog.c - rename dialog box and ftp routines                     */
/*  Copyright (C) 1998-1999 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "ftp.h"

static void dorenCB (GtkWidget *widget, struct dialog_data *data);
static struct ftp_file_data *curfle;

void rename_dialog (gpointer data) {
   struct ftp_window_data *wdata;
   GList *templist;
   char *tempstr;
   
   wdata = (struct ftp_window_data *) data;
   if (!check_status (_("Rename"), wdata, 1, 1, wdata->hdata->ftpdata->rename != NULL)) return;
   if ((templist = get_next_selected_filename (wdata->hdata->files)) == NULL) {
      ftp_log (gftp_logging_misc, NULL, _("Internal gFTP Error: Could not find a selected file. This is probably a bug. Please email masneyb@seul.org about it\n"));
      return;
   }
   curfle = (struct ftp_file_data *) templist->data;

   tempstr = g_strdup_printf (_("What would you like to rename %s to?"), curfle->file);
   MakeEditDialog (_("Rename"), tempstr, curfle->file, 1, 1,
   	_("Rename"), dorenCB, wdata, 
   	_("  Cancel  "), NULL, NULL);
   g_free (tempstr);
}
/*****************************************************************************/
static void dorenCB (GtkWidget *widget, struct dialog_data *data) {
   struct ftp_window_data *wdata;
   char *edttext;
   int success;

   wdata = (struct ftp_window_data *) data->data;
   edttext = gtk_entry_get_text (GTK_ENTRY (data->edit));
   if (*edttext == '\0') {
     ftp_log (gftp_logging_misc, NULL, _("Rename: Operation canceled...you must enter a string\n"));
     return;
   }
   if (wdata->local == 1) {
      success = rename (curfle->file, edttext) == 0;
      if (!success) {
         ftp_log (gftp_logging_misc, NULL, _("Error: Could not rename %s to %s: %s\n"), curfle->file, edttext, g_strerror (errno));
      }
      else {
         ftp_log (gftp_logging_misc, NULL, _("Successfully renamed %s to %s\n"), curfle->file, edttext);
      }
   }
   else {
      if (wdata->local == 2 && !ftp_connect (wdata->hdata, 0)) success = 0;
      else success = gftp_rename_file (wdata->hdata->ftpdata, curfle->file, edttext) == 0;
   }
   if (success) refresh ((gpointer) wdata);
}
/*****************************************************************************/
