/*
 changeuser.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gmasqdialer.h"

#include <unistd.h>
#include <pwd.h>

gboolean user_sent;

void passwd_dialog(gboolean simple, GtkObject *object, GtkSignalFunc eventfunc)
{
    GtkWidget *dialog;
    GtkWidget *hbox;
    GtkWidget *label;
    GtkWidget *entry;
    struct passwd *pw;

    /* ask user name & password */
#ifdef HAVE_GNOME
    dialog = gnome_dialog_new(_("Password needed"), GNOME_STOCK_BUTTON_OK, GNOME_STOCK_BUTTON_CANCEL, NULL);
    gnome_dialog_button_connect(GNOME_DIALOG(dialog), 0, eventfunc, dialog);
    gnome_dialog_button_connect_object(GNOME_DIALOG(dialog), 1,
                                       GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));
#else
    GtkWidget *vbox, *buthbox;
    GtkWidget *button;

    dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_container_border_width(GTK_CONTAINER(dialog), 5);
    gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                       GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(dialog), vbox);

    buthbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_end(GTK_BOX(vbox), buthbox, FALSE, FALSE, 10);

    button = gtk_button_new_with_label(_("OK"));
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked", eventfunc, GTK_OBJECT(dialog));
    gtk_box_pack_start(GTK_BOX(buthbox), button, TRUE, TRUE, 10);

    button = gtk_button_new_with_label(_("Cancel"));
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                              GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));

    gtk_box_pack_start(GTK_BOX(buthbox), button, TRUE, TRUE, 10);
#endif
    if (!simple)
    {
        gtk_object_set_data(GTK_OBJECT(dialog), "name", gtk_object_get_data(object, "name"));

        label = gtk_label_new(_("Only these users are allowed to use this connection:"));
#ifdef HAVE_GNOME
        gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
#else
        gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
#endif

        label = gtk_label_new(gtk_object_get_data(object, "users"));
#ifdef HAVE_GNOME
        gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
#else
        gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
#endif
    }

    hbox = gtk_hbox_new(FALSE, 0);
#ifdef HAVE_GNOME
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), hbox, TRUE, TRUE, 0);
#else
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
#endif
    label = gtk_label_new(_("Username:"));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, FALSE, 0);
    gtk_object_set_data(GTK_OBJECT(dialog), "user", entry);

    if (username != NULL && *username != '\0')
        gtk_entry_set_text(GTK_ENTRY(entry), username);
    else
    {
        pw = getpwuid(getuid());
        gtk_entry_set_text(GTK_ENTRY(entry), pw->pw_name);
    }

    hbox = gtk_hbox_new(FALSE, 0);
#ifdef HAVE_GNOME
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), hbox, TRUE, TRUE, 0);
#else
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
#endif
    label = gtk_label_new(_("Password:"));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    entry = gtk_entry_new();
    gtk_entry_set_visibility(GTK_ENTRY(entry), FALSE);
    gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, FALSE, 0);
    gtk_object_set_data(GTK_OBJECT(dialog), "pass", entry);
    gtk_widget_grab_focus(entry);
    gtk_signal_connect(GTK_OBJECT(entry), "activate", eventfunc, dialog);

    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    gtk_widget_show_all(dialog);
}

void senduser_event(GtkWidget *widget, GtkWidget *dialog)
{
    GtkEntry *user, *pass;

    user = gtk_object_get_data(GTK_OBJECT(dialog), "user");
    pass = gtk_object_get_data(GTK_OBJECT(dialog), "pass");

    mserver_setuser(gtk_entry_get_text(user), NULL);
    mserver_setpass(gtk_entry_get_text(pass), NULL);

    user_sent = TRUE;

    gtk_widget_destroy(dialog);
}

void menu_changeuser(void)
{
    passwd_dialog(TRUE, NULL, GTK_SIGNAL_FUNC(senduser_event));
}
