
/***

othfilter.h - declarations for the non-TCP filter module
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997
			
***/

#include <sys/types.h>
#include <netinet/udp.h>
#include "utfilter.h"

struct othpoptions {
    char filename[FLT_FILENAME_MAX];	/* these are for the UDP filters */
    struct filterlist fl;
    unsigned int filtercode;

    u_int16_t udp:1, icmp:1, ospf:1, igp:1, igmp:1, igrp:1, arp:1, rarp:1,
     nonip:1, padding:7;
};

void othfilterselect(struct othpoptions *filter);
void loadothfilter(struct othpoptions *filter);
void saveothfilter(struct othpoptions *filter);
int othfilterok(struct othpoptions *filter, unsigned int protocol,
		unsigned long saddr, unsigned long daddr,
		unsigned int sport, unsigned int dport);
