#define PLUGIN_NAME "proxy"

typedef struct
{
    PLUGIN_REC *plugin;
    gboolean loaded;
    gint gui;

    IPADDR ip;
    gint port;
    gchar *password;

    gint listen_tag;
    gint listen_handle;

    GList *clients;
}
PLUGIN_DATA;

typedef struct
{
    GString *buffer;

    gchar *nick;
    gint handle;
    gint tag;

    SERVER_REC *server;
    gboolean pass_sent;
    gboolean connected;
}
CLIENT_REC;

void plugin_proxy_setup_init(PLUGIN_REC *plugin);
void plugin_proxy_setup_deinit(PLUGIN_REC *plugin);

void plugin_proxy_listen_init(PLUGIN_DATA *data);
void plugin_proxy_listen_deinit(PLUGIN_DATA *data);

void plugin_proxy_dump_data(CLIENT_REC *client);
