#ifndef __GTK_ITEXT_H__
#define __GTK_ITEXT_H__

#include <gdk/gdk.h>
#include <gtk/gtkadjustment.h>
#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif

#define GTK_ITEXT(obj)          GTK_CHECK_CAST (obj, gtk_itext_get_type (), GtkIText)
#define GTK_ITEXT_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, GtkIText_get_type (), GtkITextClass)
#define GTK_IS_ITEXT(obj)       GTK_CHECK_TYPE (obj, gtk_itext_get_type ())

#define ITEXT_BG_SCROLLABLE     0x0001
#define ITEXT_BG_SCALED         0x0002
#define ITEXT_BG_SHADED         0x0004
#define ITEXT_BG_TRANSPARENT    0x0008

#define ITEXT_LINECOL_BOLD	0x0001
#define ITEXT_LINECOL_UNDERLINE 0x0002
#define ITEXT_LINECOL_BG        0x0004

typedef struct _GtkIText        GtkIText;
typedef struct _GtkITextClass   GtkITextClass;
typedef struct _GtkITextLine    GtkITextLine;
typedef struct _GtkITextLineCol GtkITextLineCol;

struct _GtkITextLineCol
{
    GdkColor fg, bg;
    gint flags;
    gint pos;
};

struct _GtkITextLine
{
    gchar *str;
    gint length;

    gint first:1; /* Start of the line */
    gint cont:1; /* Same line continues to next line record too */

    gint indent_chars; /* Indentation position in characters */
    gint indent_pix; /* Indentation position in pixels */

    gint pixels; /* Line length in pixels */
    gint last_space; /* Last space position */
    gint last_space_pixels; /* Pixels after last space */

    GList *colors; /* Line colors */

    /* text selection */
    gint select_start;
    gint select_end;
};

struct _GtkIText
{
    GtkWidget widget;

    GtkAdjustment *adjustment;

    GdkFont *font; /* Font in use */
    GdkFont *font_bold; /* Font in use */
    gint font_width, bfont_width, font_height; /* average font letter size */
    gint min_width; /* Minimum width of window */

    gint width, height; /* window size */
    gint starty; /* number of the first line displayed in screen */
    gint fixy; /* kludge :) */

    GList *lines_add; /* Add these lines after realized */

    GList *lines; /* Lines */
    gint linecount; /* Number of lines */

    gint last_line_num; /* Last accessed line number */
    GList *last_line; /* Pointer to last accessed line */

    GdkColor select_fg, select_bg; /* Text selection colors */
    GdkColor nselect_fg, nselect_bg; /* Text selection colors when we don't own selection */
    gboolean own_selection; /* Do we own selection? */

    gint select_start; /* Text selection starts at line */
    gint select_end; /* Text selection ends at line */
    gboolean selecting; /* Mouse button is still down.. */

    GdkGC *fore_gc, *back_gc, *tback_gc;

    gint refresh_first; /* first line that needs refreshing, -1 = none */
    gint refresh_last; /* last line that needs refreshing */
    gint freeze;

    /* background */
    GdkColor back_color;
    GdkPixmap *pixmap;
    gchar *pixmap_path;
    gint bg_flags;
};

struct _GtkITextClass
{
    GtkWidgetClass parent_class;

    void (*word_clicked) (GtkIText *itext, gchar *word, GdkEventButton *event);
};

GtkType gtk_itext_get_type(void);
GtkWidget *gtk_itext_new(void);

void gtk_itext_set_fonts(GtkIText *itext, GdkFont *font_normal, GdkFont *font_bold);
void gtk_itext_set_background(GtkIText *itext, GdkColor *color, gchar *pixmap, gint flags);

void gtk_itext_append(GtkIText *itext, gchar *str, GdkColor *fg, GdkColor *bg, gint flags, gint indent);
void gtk_itext_remove_first_line(GtkIText *itext);
void gtk_itext_clear(GtkIText *itext);

void gtk_itext_get_selection(GtkIText *itext);

void gtk_itext_freeze(GtkIText *itext);
void gtk_itext_thaw(GtkIText *itext);

#ifdef __cplusplus
}
#endif

#endif
