#ifndef __GUI_WINDOWS_H
#define __GUI_WINDOWS_H

#define WINDOW_GUI(a) ((GUI_WINDOW_REC *) ((a)->gui_data))

typedef struct
{
    gushort *line; /* color, character, color, character, .. */
    gint linelen;
    gint loglevel;
    gboolean next_joined;
    time_t time;
}
LINE_REC;

typedef struct
{
    MAIN_WINDOW_REC *parent;

    GSList *lines;
    LINE_REC *cur_line;

    gint xpos, ypos;
    gint starty;

    gchar *next_line; /* for gui-printtext.c */
    gint line_pos;
}
GUI_WINDOW_REC;

void gui_windows_init(void);
void gui_windows_deinit(void);

WINDOW_REC *gui_window_create(MAIN_WINDOW_REC *parent);

void gui_window_redraw(WINDOW_REC *window);
void gui_window_set_server(WINDOW_REC *window, SERVER_REC *server);

GSList *gui_window_find_text(WINDOW_REC *window, gchar *text);

#endif
