#ifndef __PLUGINS_H
#define __PLUGINS_H

#define PLUGIN_LAYER_VERSION 3

typedef struct
{
    GModule *module;

    gchar *name;
    gchar *description;

    gpointer data; /* free for plugin to use */
    GHashTable *signals;

    gpointer gui_data;
}
PLUGIN_REC;

/* plugin_init: initialize plugin

   return value:
     if plugin doesn't want to get loaded it should return FALSE
*/
typedef gboolean (*PLUGIN_INIT_FUNC) (gint gui, PLUGIN_REC *plugin, gchar *args);

/* plugin_deinit: deinitialize plugin */
typedef void (*PLUGIN_DEINIT_FUNC) (PLUGIN_REC *);

/* plugin_description: Get plugin description */
typedef gchar* (*PLUGIN_DESC_FUNC) (void);

/* plugin_version: Get plugin version */
typedef gint (*PLUGIN_VERSION_FUNC) (void);

extern GList *plugins;

gboolean plugin_load(gchar *name, gchar *args);
void plugin_destroy(PLUGIN_REC *plugin);

gchar *plugin_get_description(gchar *name);
PLUGIN_REC *plugin_find(gchar *name);

void plugins_init(void);
void plugins_deinit(void);

#endif
