;;; liece-q-ccl.el --- CTCP binary data quotation in CCL.
;; Copyright (C) 1998, 1999 Daiki Ueno

;; Author: Daiki Ueno <ueno@ueda.info.waseda.ac.jp>
;; Created: 1999-01-31
;; Revised: 1999-01-31
;; Keywords: IRC, liece, CTCP

;; This file is part of Liece.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(require 'broken)
(require 'pccl)

(eval-and-compile
  (defconst liece-quote-ccl-256-table
    '(  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15
       16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31
       32  33  34  35  36  37  38  39  40  41  42  43  44  45  46  47
       48  49  50  51  52  53  54  55  56  57  58  59  60  61  62  63
       64  65  66  67  68  69  70  71  72  73  74  75  76  77  78  79
       80  81  82  83  84  85  86  87  88  89  90  91  92  93  94  95
       96  97  98  99 100 101 102 103 104 105 106 107 108 109 110 111
      112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127
      128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143
      144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159
      160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175
      176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191
      192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207
      208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223
      224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239
      240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255)))

(broken-facility ccl-set-register-right
  "Emacs CCL = does not accept register in righthand sentence."
  (condition-case nil
      (progn
	(define-ccl-program set-register-right-test
	  '(1
	    (r0 = r1)))
	t)
    (error nil)))

(broken-facility ccl-cascading-write
  "Emacs CCL write command does not accept more than 2 arguments."
  (condition-case nil
      (progn
	(define-ccl-program cascading-read-test
	  '(1
	    (write r0 r1 r2)))
	t)
    (error nil)))
 
(define-ccl-program liece-quote-ccl-decode
  (` (1
      (loop
	(read-if 
	 (r0 == ?\\)
	 ((read-if 
	   (r1 == ?\\)
	   (read r2)
	   (, (if-broken ccl-set-register-right
		  (` (r2 = (r1 & r1)))
		(` (r2 = r1)))))
	  (branch
	   r2
	   (,@ (mapcar
		(lambda (r2)
		  (cond
		   ((= r2 (char-int ?a))
		    (` (write 1)))
		   ((= r2 (char-int ?n))
		    (` (write ?\n)))
		   ((= r2 (char-int ?r))
		    (` (write ?\r)))
		   (t 
		    (if-broken ccl-cascading-write
			(` ((write r0)
			    (write r1)
			    (write r2)))
		      (` (write r0 r1 r2))))))
		liece-quote-ccl-256-table))
	   (write r0))
	  (repeat)))))))

(define-ccl-program liece-quote-ccl-encode
  (` (2
      (loop
	(read-branch
	 r0
	 (,@ (mapcar
	      (lambda (r0)
		(cond 
		 ((= r0 (char-int ?\\))
		  (` (write-repeat "\\\\")))
		 ((= r0 1)
		  (` (write-repeat "\\a")))
		 ((= r0 (char-int ?\n))
		  (` (write-repeat "\\n")))
		 ((= r0 (char-int ?\r))
		  (` (write-repeat "\\r")))
		 (t 
		  (` (write-repeat r0)))))
	      liece-quote-ccl-256-table)))))))

(make-ccl-coding-system
 'liece-quote-ccl-cs ?Q "CTCP Quote Decoder/Encoder"
 'liece-quote-ccl-decode 'liece-quote-ccl-encode)

(defun liece-quote-ccl-decode-string (string-to-decode)
  (decode-coding-string string-to-decode 'liece-quote-ccl-cs))

(defun liece-quote-ccl-encode-string (string-to-encode)
  (encode-coding-string string-to-encode 'liece-quote-ccl-cs))

(defun liece-quote-ccl-decode-region (min max)
  (decode-coding-region min max 'liece-quote-ccl-cs))

(defun liece-quote-ccl-encode-region (min max)
  (encode-coding-region min max 'liece-quote-ccl-cs))

(defalias 'liece-quote-decode-string 'liece-quote-ccl-decode-string)
(defalias 'liece-quote-encode-string 'liece-quote-ccl-encode-string)

(defalias 'liece-quote-decode-region 'liece-quote-ccl-decode-region)
(defalias 'liece-quote-encode-region 'liece-quote-ccl-encode-region)

(provide 'liece-q-ccl)

;;; liece-q-ccl.el ends here.
