#include "links.h"

struct dnsentry {
	struct dnsentry *next;
	struct dnsentry *prev;
	ttime get_time;
	ip addr;
	char name[1];
};

#define DNS_PIPE_BUFFER	32

struct dnsquery {
	void (*fn)(void *, int);
	void *data;
	void (*xfn)(struct dnsquery *, int);
	int h;
	struct dnsquery **s;
	ip *addr;
	char name[1];
};

struct list_head dns_cache = {&dns_cache, &dns_cache};

int do_real_lookup(unsigned char *name, ip *host)
{
	struct hostent *hst;
	if (!(hst = gethostbyname(name))) return -1;
	memcpy(host, hst->h_addr_list[0], sizeof(ip));
	return 0;
}

void lookup_fn(unsigned char *name, int h)
{
	ip host;
	if (do_real_lookup(name, &host)) return;
	write(h, &host, sizeof(ip));
}

void end_real_lookup(struct dnsquery *q)
{
	int r = 1;
	if (read(q->h, q->addr, sizeof(ip)) != sizeof(ip)) goto end;
	r = 0;

	end:
	set_handlers(q->h, NULL, NULL, NULL, NULL);
	close(q->h);
	q->xfn(q, r);
}

void failed_real_lookup(struct dnsquery *q)
{
	set_handlers(q->h, NULL, NULL, NULL, NULL);
	close(q->h);
	q->xfn(q, -1);
}

void do_lookup(struct dnsquery *q, void (*fn)(struct dnsquery *, int))
{
	struct hostent *host;
#ifndef NO_ASYNC_LOOKUP
	if (!async_lookup) {
#endif
		int r;
		sync_lookup:
		r = do_real_lookup(q->name, q->addr);
		fn(q, r);
#ifndef NO_ASYNC_LOOKUP
	} else {
		if ((q->h = start_thread((void (*)(void *, int))lookup_fn, q->name, strlen(q->name) + 1)) == -1) goto sync_lookup;
		q->xfn = fn;
		set_handlers(q->h, (void (*)(void *))end_real_lookup, NULL, (void (*)(void *))failed_real_lookup, q);
	}
#endif
}

int find_in_dns_cache(char *name, struct dnsentry **dnsentry)
{
	struct dnsentry *e;
	foreach(e, dns_cache)
		if (!strcasecmp(e->name, name)) {
			del_from_list(e);
			add_to_list(dns_cache, e);
			*dnsentry=e;
			return 0;
		}
	return -1;
}

void end_dns_lookup(struct dnsquery *q, int a)
{
	struct dnsentry *dnsentry;
	void (*fn)(void *, int);
	void *data;
	if (!find_in_dns_cache(q->name, &dnsentry)) {
		if (a) {
			memcpy(q->addr, &dnsentry->addr, sizeof(ip));
			a = 0;
			goto e;
		}
		del_from_list(dnsentry);
		mem_free(dnsentry);
	}
	if (a) goto e;
	if ((dnsentry = mem_alloc(sizeof(struct dnsentry) + strlen(q->name) + 1))) {
		strcpy(dnsentry->name, q->name);
		memcpy(&dnsentry->addr, q->addr, sizeof(ip));
		dnsentry->get_time = get_time();
		add_to_list(dns_cache, dnsentry);
	}
	e:
	if (q->s) *q->s = NULL;
	fn = q->fn;
	data = q->data;
	mem_free(q);
	fn(data, a);
}

void find_host_no_cache(unsigned char *name, ip *addr, void **qp, void (*fn)(void *, int), void *data)
{
	struct dnsquery *q;
	if (!(q = mem_alloc(sizeof(struct dnsquery) + strlen(name) + 1))) {
		fn(data, -1);
		return;
	}
	q->fn = fn;
	q->data = data;
	q->s = (struct dnsquery **)qp;
	q->addr = addr;
	strcpy(q->name, name);
	if (qp) *(struct dnsquery **) qp = q;
	do_lookup(q, end_dns_lookup);
}

void find_host(unsigned char *name, ip *addr, void **qp, void (*fn)(void *, int), void *data)
{
	struct dnsentry *dnsentry;
	if (qp) *qp = NULL;
	if (!find_in_dns_cache(name, &dnsentry)) {
		if (dnsentry->get_time + DNS_TIMEOUT < get_time()) goto timeout;
		memcpy(addr, &dnsentry->addr, sizeof(ip));
		fn(data, 0);
		return;
	}
	timeout:
	find_host_no_cache(name, addr, qp, fn, data);
}

void kill_dns_request(void **qp)
{
	struct dnsquery *q = *qp;
	set_handlers(q->h, NULL, NULL, NULL, NULL);
	close(q->h);
	mem_free(q);
	*qp = NULL;
}

void shrink_dns_cache(int u)
{
	struct dnsentry *d, *e;
	foreach(d, dns_cache) if (u || d->get_time + DNS_TIMEOUT < get_time()) {
		e = d;
		d = d->prev;
		del_from_list(e);
		mem_free(e);
	}
}
