#include "links.h"

void check_shell_security(unsigned char **cmd)
{
	unsigned char *c = *cmd;
	while (*c) {
		if (!(*c == '+' || *c == '-' || *c == '.' || (*c >= '0' && *c <= '9') || (*c >= 'A' && *c <= 'Z') || *c == '_' || (*c >= 'a' && *c <= 'z'))) *c = '_';
		c++;
	}
}

#if defined(UNIX)

#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif
/*#include <ioctls.h>
#include <ioctl-types.h>*/

#ifdef HAVE_LIBGPM
#include <gpm.h>
#endif

void (*resize_fn)();

void sigwinch(void *s)
{
	((void (*)())s)();
}

void handle_terminal_resize(int fd, void (*fn)())
{
	install_signal_handler(SIGWINCH, sigwinch, fn, 0);
}

void unhandle_terminal_resize(int fd)
{
	install_signal_handler(SIGWINCH, NULL, NULL, 0);
}

int get_terminal_size(int fd, int *x, int *y)
{
	struct winsize ws;
	if (ioctl(fd, TIOCGWINSZ, &ws) != -1) {
		if (x) if (!(*x = ws.ws_col)) *x = 80;
		if (y) if (!(*y = ws.ws_row)) *y = 24;
		return 0;
	}
	return -1;
}

void set_bin(int fd)
{
}

int c_pipe(int *fd)
{
	return pipe(fd);
}

int check_file_name(unsigned char *file)
{
	return 1;		/* !!! FIXME */
}

#elif defined(OS2)

#define INCL_MOU
#include <os2.h>
#include <io.h>
#include <process.h>

void handle_terminal_resize(int fd, void (*fn)())
{
}

void unhandle_terminal_resize(int fd)
{
}

int get_terminal_size(int fd, int *x, int *y)
{
	int a[2];
	a[0] = a[1] = 0;
	_scrsize(a);
	if (x) if (!(*x = a[0])) *x = 80;
	if (y) if (!(*y = a[1])) *y = 24;
	return 0;
}

void set_bin(int fd)
{
	setmode(fd, O_BINARY);
}

int c_pipe(int *fd)
{
	int r = pipe(fd);
	if (!r) set_bin(fd[0]), set_bin(fd[1]);
	return r;
}

int check_file_name(unsigned char *file)
{
	return 1;		/* !!! FIXME */
}

int exe(char *path)
{
	int pid, ret;
	char *shell;
	if (!(shell = GETSHELL)) shell = DEFAULT_SHELL;
	if ((pid = spawnlp(P_SESSION, shell, shell, "/c", path, NULL)) != -1)
		waitpid(pid, &ret, 0);
	else ret = -1;
	return ret;
}

#else
#error Unknown system
#endif

#ifndef HAVE_BEGINTHREAD

int start_thread(void (*fn)(void *, int), void *ptr, int l)
{
	int p[2];
	if (c_pipe(p) < 0) return -1;
	if (!fork()) {
		close(p[0]);
		fn(ptr, p[1]);
		write(p[1], "x", 1);
		close(p[1]);
		exit(0);
	}
	close(p[1]);
	return p[0];
}

#else

struct tdata {
	void (*fn)(void *, int);
	int h;
	unsigned char data[1];
};

void bgt(struct tdata *t)
{
	signal(SIGPIPE, SIG_IGN);
	t->fn(t->data, t->h);
	write(t->h, "x", 1);
	close(t->h);
	free(t);
}

int start_thread(void (*fn)(void *, int), void *ptr, int l)
{
	int p[2];
	struct tdata *t;
	if (c_pipe(p) < 0) return -1;
	if (!(t = malloc(sizeof(struct tdata) + l))) return -1;
	t->fn = fn;
	t->h = p[1];
	memcpy(t->data, ptr, l);
	if (_beginthread((void (*)(void *))bgt, NULL, 65536, t) == -1) {
		mem_free(t);
		return -1;
	}
	return p[0];
}

#ifdef HAVE_READ_KBD
int tp = -1;
int ti = -1;

void input_thread(void *p)	/* !!! FIXME: race-condition with mouse */
{
	char c[2];
	int h = (int)p;
	while (1) {
		/*c[0] = _read_kbd(0, 1, 1);
		if (c[0]) if (write(h, c, 1) <= 0) break;
		else {
			int w;
			printf("1");fflush(stdout);
			c[1] = _read_kbd(0, 1, 1);
			printf("2");fflush(stdout);
			w = write(h, c, 2);
			printf("3");fflush(stdout);
			if (w <= 0) break;
			if (w == 1) if (write(h, c+1, 1) <= 0) break;
			printf("4");fflush(stdout);
		}*/ *c = _read_kbd(0, 1, 1), write(h, c, 1);
	}
	close(h);
}
#endif

#ifdef HAVE_MOUOPEN

#define A_DECL(type, var) type var##1, var##2, *var = _THUNK_PTR_STRUCT_OK(&var##1) ? &var##1 : &var##2

void mouse_thread(void *p)
{
	int h = (int)p;
	A_DECL(HMOU, mh);
	A_DECL(MOUEVENTINFO, ms);
	A_DECL(USHORT, rd);
	A_DECL(USHORT, mask);
	if (MouOpen(NULL, mh)) return;
	*mask = MOUSE_MOTION_WITH_BN1_DOWN | MOUSE_BN1_DOWN |
		MOUSE_MOTION_WITH_BN2_DOWN | MOUSE_BN2_DOWN |
		MOUSE_MOTION_WITH_BN3_DOWN | MOUSE_BN3_DOWN;
	MouSetEventMask(mask, *mh);
	*rd = MOU_WAIT;
	MouDrawPtr(*mh);
	while (1) {
		char str[6] = "\033[Mxxx";
		int w, ww;
		if (MouReadEventQue(ms, rd, *mh)) break;
		str[3] = ' ';
		if (ms->fs & (MOUSE_BN1_DOWN | MOUSE_BN2_DOWN | MOUSE_BN3_DOWN)) str[3] |= ms->fs & MOUSE_BN1_DOWN ? 0 : ms->fs & MOUSE_BN2_DOWN ? 1 : 2;
		else if (ms->fs & (MOUSE_MOTION_WITH_BN1_DOWN | MOUSE_MOTION_WITH_BN2_DOWN | MOUSE_MOTION_WITH_BN3_DOWN)) str[3] |= ms->fs & MOUSE_MOTION_WITH_BN1_DOWN ? 4 : ms->fs & MOUSE_MOTION_WITH_BN2_DOWN ? 5 : ms->fs & MOUSE_MOTION_WITH_BN3_DOWN ? 6 : 4;
		else str[3] |= 3;
		str[4] = ' ' + 1 + ms->col;
		str[5] = ' ' + 1 + ms->row;
		for (w = 6; w > 0; w -= ww) if ((ww = write(h, str + 6 - w, w)) <= 0) break;
	}
	MouClose(*mh);
}

#endif

#endif

#if defined(HAVE_BEGINTHREAD) && defined(HAVE_READ_KBD)
int get_input_handle()
{
	int fd[2];
	if (ti != -1) return ti;
	c_pipe(fd);
	ti = fd[0];
	tp = fd[1];
	_beginthread(input_thread, NULL, 0x10000, (void *)tp);
#if defined(HAVE_MOUOPEN) && !defined(HAVE_LIBGPM)
	_beginthread(mouse_thread, NULL, 0x10000, (void *)tp);
#endif
	return fd[0];
}
#else
int get_input_handle()
{
	return 0;
}
#endif


#ifndef HAVE_CFMAKERAW
void cfmakeraw(struct termios *t)
{
	t->c_iflag &= ~(IGNBRK|BRKINT|PARMRK|ISTRIP|INLCR|IGNCR|ICRNL|IXON);
	t->c_oflag &= ~OPOST;
	t->c_lflag &= ~(ECHO|ECHONL|ICANON|ISIG|IEXTEN);
	t->c_cflag &= ~(CSIZE|PARENB);
	t->c_cflag |= CS8;
	t->c_cc[VMIN] = 1;
	t->c_cc[VTIME] = 0;
}
#endif

#ifdef HAVE_LIBGPM

struct gpm_mouse_spec {
	int h;
	void (*fn)(void *, unsigned char *, int);
	void *data;
};

void gpm_mouse_in(struct gpm_mouse_spec *gms)
{
	Gpm_Event gev;
	struct event ev;
	if (Gpm_GetEvent(&gev) <= 0) {
		set_handlers(gms->h, NULL, NULL, NULL, NULL);
		return;
	}
	ev.ev = EV_MOUSE;
	ev.x = gev.x - 1;
	ev.y = gev.y - 1;
	if (gev.buttons & GPM_B_LEFT) ev.b = B_LEFT;
	else if (gev.buttons & GPM_B_MIDDLE) ev.b = B_MIDDLE;
	else if (gev.buttons & GPM_B_RIGHT) ev.b = B_RIGHT;
	else return;
	if (gev.type & GPM_DOWN) ev.b |= B_DOWN;
	else if (gev.type & GPM_UP) ev.b |= B_UP;
	else if (gev.type & GPM_DRAG) ev.b |= B_DRAG;
	else return;
	gms->fn(gms->data, (char *)&ev, sizeof(struct event));
}

void *handle_mouse(int cons, void (*fn)(void *, unsigned char *, int), void *data)
{
	int h;
	Gpm_Connect conn;
	struct gpm_mouse_spec *gms;
	conn.eventMask = ~GPM_MOVE;
	conn.defaultMask = GPM_MOVE;
	conn.minMod = 0;
	conn.maxMod = 0;
	if ((h = Gpm_Open(&conn, cons)) < 0) return NULL;
	if (!(gms = mem_alloc(sizeof(struct gpm_mouse_spec)))) return NULL;
	gms->h = h;
	gms->fn = fn;
	gms->data = data;
	set_handlers(h, (void (*)(void *))gpm_mouse_in, NULL, NULL, gms);
	return gms;
}

void unhandle_mouse(void *h)
{
	struct gpm_mouse_spec *gms = h;
	set_handlers(gms->h, NULL, NULL, NULL, NULL);
	Gpm_Close();
	mem_free(gms);
}

#else

void *handle_mouse(int cons, void (*fn)(void *, unsigned char *, int), void *data) { return NULL; }
void unhandle_mouse(void *data) { }

#endif

