#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <sysexits.h>
#include <unistd.h>

void parse(int);								/* grammar.y */
extern FILE *yyin;

static char **av;
static int ac, input;

int main(int argc, char **argv) {
	int c, outfd;
	char *outpath = "lsf.out";
	
	while((c = getopt(argc, argv, "o:")) != -1) {
		switch(c) {
			case 'o':
				outpath = optarg;
				break;
			default:
				fprintf(stderr, "%s: unknown option character %c\n", argv[0], c);
				break;
		}
	}
	if(optind < argc)
		if(!(yyin = fopen(argv[optind], "r"))) {
			perror("fopen");
			exit(EX_NOINPUT);
		}
	av = argv;
	ac = argc;
	input = optind + 1;
	if((outfd = open(outpath, O_WRONLY|O_CREAT|O_TRUNC, 0666)) < 0) {
		perror("open");
		exit(EX_CANTCREAT);
	}
	parse(outfd);
	if(close(outfd)) {
		perror("close");
		exit(EX_OSERR);
	}
	exit(0);
}

int yywrap() {
	if(input >= ac)
		return 1;
	fclose(yyin);
	if(!(yyin = fopen(av[input++], "r"))) {
		perror("fopen");
		exit(EX_NOINPUT);
	}
	return 0;
}
