/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    This code was contributed by Shane Kerr <kerr@wizard.net>
*/

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>

static int can_execute(const char *fname)
{
	struct stat stbuf;

	if (stat(fname, &stbuf) == -1)
	{
		return 0;
	}

	if (stbuf.st_mode & S_IXOTH)
	{
		return 1;
	}

	if (getegid() == stbuf.st_gid)
	{
		if (stbuf.st_mode & S_IXGRP) {
			return 1;
		}
	}

	if (geteuid() == stbuf.st_uid)
	{
		if (stbuf.st_mode & S_IXUSR) {
			return 1;
		}
	}

	return 0;
}

const char *get_exe_name(const char *argv0)
{
	static char name[PATH_MAX];

	char *path;
	char *colon_pos;
	int path_len;

	/* if a path has already been partially specified */
	if (strchr(argv0, '/') != NULL)
	{
		strcpy(name, argv0);
		return name;
	}

	/* otherwise search the path */
	path = getenv("PATH");
	while (*path != '\0')
	{
		colon_pos = strchr(path, ':');
		if (colon_pos == NULL)
		{
			colon_pos = path + strlen(path);
		}

		path_len = 0;

		while (path != colon_pos)
		{
			name[path_len] = *path;
			path_len++;
			path++;
		}
		name[path_len] = '\0';

		if (path_len > 0)
		{
			if (name[path_len - 1] != '/')
			{
				strcat(name, "/");
			}

			strcat(name, argv0);

			if (can_execute(name))
			{
				return name;
			}
		}
		path = colon_pos + 1;
	}

	/* if we didn't find one, return error */
	return NULL;
}
