!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  bcc_lshr.S
!* Purpose: Routines required by bcc
!* Entries: lsrl, lsrul
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! Start code segment.
!
	.text


! If we are using the peephole optimizer for BCC all routines in this
! file should be unnecessary, so prevent it from getting included by
! disabling all public definitions.
#ifndef OPT386
	public	lsrl		! define entry points
	public	lsrul
#endif


!
!**************************************************************************
!
! Define BCC support functions
!
! Shift arithmetic right
lsrl:	mov	cx,di
	cmp	cx,#32
	jb	lsrl1
	mov	cx,#32
lsrl1:
#ifdef IS386
	shrd	ax,bx,cl
	sar	bx,cl
#else
	jcxz	lsrl9
lsrl2:	sar	bx,#1
	rcr	ax,#1
	loop	lsrl2
#endif
lsrl9:	ret


! Shift right
lsrul:	mov	cx,di
	cmp	cx,#32
	jae	lsrul8
#ifdef IS386
	shrd	ax,bx,cl
	shr	bx,cl
#else
	jcxz	lsrul9
lsrul1:	shr	bx,*1
	rcr	ax,*1
	loop	lsrul1
#endif
lsrul9:	ret

lsrul8:	xor	ax,ax
	mov	bx,ax
	ret


!
!**************************************************************************
!
	end

