.\" @(#)makerom.8
.\"
.\" Copyright (C) 1997,1998 Gero Kuhlmann   <gero@gkminix.han.de>
.\"
.\"  This program is free software; you can redistribute it and/or modify
.\"  it under the terms of the GNU General Public License as published by
.\"  the Free Software Foundation; either version 2 of the License, or
.\"  any later version.
.\"
.\"  This program is distributed in the hope that it will be useful,
.\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"  GNU General Public License for more details.
.\"
.\"  You should have received a copy of the GNU General Public License
.\"  along with this program; if not, write to the Free Software
.\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH MAKEROM 8 "11 May 1997"
.SH NAME
makerom \- Make bootrom image

.SH SYNOPSIS
.LP
.B makerom
[OPTIONS]

.SH DESCRIPTION
.B makerom
generates an IP
.SM Boot-Rom
either interactively or in batch mode. It works by first concatenating
the bootrom kernel file with the program driver files (like packet driver
etc.), then compressing the resulting image and concatenating it with
either the floppy or the rom loader stubs.

.SH OPTIONS
.TP
.B \-b, \-\-batch-sys SYS
Lets
.B makerom
operate in batch mode. It will look up the given system name in a
database file and generate a bootrom according to the specifications
given in the database entry. If this option is not given,
.B makerom
will operate in interactive mode, asking the user about all required
parameters on the console.
.TP
.B \-C, \-\-config-file FILE
Specifies a configuration file.
.TP
.B \-h, \-\-help
Print short usage information.
.TP
.B \-N, \-\-netboot-dir DIR
Specifies the netboot directory where
.B makerom
looks for the files required for generating a new bootrom. If this option
is given, it will override the corresponding environment and configuration
file settings.
.TP
.B \-v, \-\-version
Print version information.
.TP
.B \-x, \-\-verbose
Increase verbosity level.

.SH CONFIGURATION FILE
The following sections and parameters in the configuration
file are used by
.BR makerom :
.TP
.B [makerom:general]
This section contains general definitions,
like in what directories to find the necessary files for building a
bootrom. It can contain these parameters:
.RS
.TP
.B kerneldir
Specifies the directory where
.B makerom
looks for kernel files to generate a list of usable kernels in interactive
mode.
.TP
.B loaderdir
Specifies the directory where the bootrom and floppy loader stubs can be
found.
.TP
.B netdrvdir
Specifies the directory where
.B makerom
looks for network driver binaries in interactive mode.
.TP
.B utilsdir
Specifies the directory where
.B makerom
looks for the utility files
.BR ansidrv.com ,
the bootrom ANSI display driver, and
.BR pktwatch.com ,
a program to debug the bootrom packet driver interface.
.LP
For all these variables two leading slashes in the value get replaced
by the name of the main netboot directory. Therefore, //kernel
gets expanded to /usr/local/lib/netboot/kernel
provided that the main netboot directory has been set to
/usr/local/lib/netboot.
.RE
.TP
.B [makerom:kernel:<kernel name>]
These sections contain descriptions for the bootrom kernels
.B makerom
uses to actually create the final bootrom image, and will only be
used in interactive mode. A configuration file can have as many kernel
sections as necessary. However, each section has to have a unique
.I <kernel name>
as an identifier. The following parameters are recognized:
.RS
.TP
.B description
This parameter requires a string value, which shortly describes the
kernel image. It will be used in interactive mode when displaying the
menu of available kernel images.
.TP
.B file
String parameter giving the name of the kernel image file. It's relative
to the kernel directory as specified by the
.B kerneldir
parameter in the general section.
.TP
.B flags
This parameter specifies certain features of the kernel image. It has to
be a string value consisting of one or several flag values.
All flags have to be separated by a comma, with no
blanks in between. The following flags are recognized (caution: case
matters!):
.RS
.TP
.B MINIMAL
Specifies a minimal kernel.
.TP
.B X86
Specifies a kernel for a 16 bit x86 processor. If this kernel is
selected in interactive mode,
.B makerom
automatically selects the corresponding 16 bit rom loader.
.RE
.RE
.TP
.B [makerom:netdrv:<driver name>]
Like with the kernel sections
these describe the network driver binaries usable by
.B makerom
to create the bootrom image. It is also used in interactive mode only.
The fields are defined as follows:
.RS
.TP
.B description
A short description of the network driver which will be used in the
network driver selection menu. This parameter is required.
.TP
.B file
This string parameter names the file to be used for this network driver. It
is relative to the directory given by the
.B netdrvdir
parameter in the general section. The
.B file
parameter is required.
.TP
.B type
Specify the type of the network driver. It is a string parameter, and it's
only recognized value presently is
.B packet
.BR driver .
If this parameter is missing, this value is also the default.
.TP
.B parameters
The string value has to contain flags which describe what network driver
command line options
.B makerom
should ask for in interactive mode. If it's empty, no parameters will be
asked for. The following flags are recognized:
.RS
.TP
.B HW_IRQ
The network driver requires specifying the hardware interrupt of the network
card.
.TP
.B IO_ADDR
The network driver requires specifying the I/O address of the network card.
.TP
.B BASE_MEM
If the network card uses shared memory, this flag tells
.B makerom
to ask the user for the base segment address of the shared memory.
.TP
.B DMA_NUM
Some network cards use a DMA line, which has to be specified to the
network driver.
.TP
.B AUI_TYPE
If the network card supports different ethernet interfaces, this flag tells
.B bootrom
to ask for the type to be used.
.RE
.TP
.B cmdline
This string value specifies how the command line to the network driver
should look like. All characters in this string are copied verbatim into
the command line, except the % character which stands for a placeholder
for certain parameters. The character following the % specifies which
parameter gets copied into the command line:
.RS
.TP
.B %S
Software interrupt for the packet driver interface (hex)
.TP
.B %H
Network card hardware interrupt (decimal)
.TP
.B %A
Network card I/O address (hex)
.TP
.B %M
Network card shared memory base address (hex)
.TP
.B %D
Network card DMA chanal number (decimal)
.TP
.B %T
Type of network interface to use (decimal)
.LP
Of course, the
.B parameters
field should specify those parameters which are actually used with the
command line. Otherwise, unpredictable substitutions may occur.
.LP
.RE
.B makerom
will use only those network driver sections for displaying the
menu, for which it can find the specified file.

.SH DATABASE FILE
The makerom sections in the database file use
[<system name>:makerom] for the tag names. They can contain the
following parameters:
.TP
.B kernel
Specifies the name of the kernel file to be used. If the name starts with
two slashes these get replaced by the name of the general netboot directory.
.TP
.B useint18
If this boolean parameter is
.BR true ,
the bootrom will use interrupt 18h for startup which is the
old BASIC startup vector on old PC's. This interrupt gets called by the
BIOS when it can't find a bootable floppy or hard disk partition. If the
value of this variable is set to
.BR false ,
the bootrom will use interrupt 19h instead, which is the PC bootstrap
interrupt. In this case, the system will not seek any hard disks in the
system for a bootable partition (but will still check the first floppy
drive), but immediately start the netboot process. The default for this
parameter is
.BR false .
.TP
.B loaderX
Specifies the file names of all bootrom loaders.
.B makerom
will create a bootrom image file for each rom loader specified. The
.B X
in the variable name can be a number from 1 to 3. For each
.B loaderX
variable there has to be a corresponding
.B outnameX
variable as well. Normal substition for the main netboot will occur.
.TP
.B outnameX
Specifies the names of the bootrom image files created with the rom loaders.
For each
.B loaderX
parameter there has to be a corresponding
.B outnameX
parameter.
.TP
.B outtypeX
This is an enumeration parameter which specifies the format of the
output file generated for each bootrom image given in
.BR outnameX .
The following values are recognized:
.RS
.TP
.B binary
Raw binary for programming an EPROM
.TP
.B intel hex
Bootrom image will be converted to Intel hex format for use with EPROM
programmers which require this format.
.TP
.B motorola hex
Bootrom image will be converted to Motorola EXORmacs hex format for use
with EPROM programmers which require this format.
.TP
.B tektronix hex
Bootrom image will be converted to Tektronix hex format for use
with EPROM programmers which require this format.
.TP
.B flash
The bootrom image will be prepended by a special boot loader which allows
it to be booted using a bootrom. It will then program a FlashCard
with the new bootrom image. This method can be used to easily update the
bootrom in a diskless client without unmounting the cover. It cannot
be used with the floppy boot loader. Therefore, the
.B loaderX
parameter has to specify a rom loader when using the
.B flash
option.
.RE
.TP
.B driverX
Specifies the file names of all driver programs (like network driver, ANSI
display driver etc.) to be loaded into the bootrom. The
.B X
in the variable name can be a number from 1 to 8. For each
.B driverX
variable there has to be a corresponding
.B argumentX
variable as well. If the file name starts with two slashes these get
substituted with the name of the main netboot directory.
.TP
.B argumentX
Specifies the command lines which have to passed to each of the drivers. The
value of an argument variable can be empty. Everything following the equal
sign up to the last non-blank character is used for the command line,
including any blanks in between.

.SH BUGS
None known yet.

.SH SEE ALSO
netboot.config(5)

.SH AUTHOR
.B makerom
was written by
.SM Gero Kuhlmann <gero@gkminix.han.de>.

