/*
 * fileio.c  -  File I/O routines
 *
 * Copyright (C) 1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define NO_BINARY 1	/* No need to include binary support here */
#include "common.h"
#include "nblib.h"
#include "privlib.h"



/*
 * Global variables exported by this module
 */
int write_chksum = 0;		/* checksum for all bytes when writing */



/*
 * Read one block of data
 */
int nbread(buf, bufsize, infile)
unsigned char *buf;
unsigned int bufsize;
int infile;
{
  int ofs;

  if ((ofs = read(infile, (char *)buf, bufsize)) < 0) {
	perror(progname);
	exit(EXIT_READ);
  }
  return(ofs);
}



/*
 * Write one block of data to the output file.
 */
int nbwrite(buf, bufsize, outfile)
unsigned char *buf;
unsigned int bufsize;
int outfile;
{
  int j, ofs;

  /* Write buffer into output file */
  if ((ofs = write(outfile, (char *)buf, bufsize)) < 0) {
	perror(progname);
	exit(EXIT_WRITE);
  }
  if (ofs != bufsize) {
	fprintf(stderr, "%s: incorrect number of bytes written\n", progname);
	exit(EXIT_WRITE);
  }

  /* Compute the checksum */
  for (j = 0; j < ofs; j++)
	write_chksum += buf[j];
  return(ofs);
}

