/*
 * This program is in the public domain and may be used freely by anyone
 * who wants to.
 *
 * Please send bug fixes/bug reports to: Peter Eriksson <pen@lysator.liu.se>
 *
 * This version elminates the kmem search in favour of a kernel sysctl to
 * get the user id associated with a connection - Bob Beck <beck@obtuse.com>
 *
 * $Id: openbsd24.c,v 1.3 1999/12/12 20:08:57 odin Exp $
 */


#include <config.h>
#include <oidentd.h>

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socketvar.h>
#include <sys/sysctl.h>

#include <netinet/in_systm.h>
#include <netinet/tcp.h>
#include <netinet/ip_var.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>

/*
 * Return the user number for the connection owner
 */

int get_user(int lport, int fport, const struct in_addr *laddr, const struct in_addr *faddr) {
	extern u_int flags;
	struct tcp_ident_mapping tir;
	struct sockaddr_in *fin, *lin;
	int mib[] = { CTL_NET, PF_INET, IPPROTO_TCP, TCPCTL_IDENT };
	int error = 0;
	size_t i;

	memset(&tir, 0, sizeof (tir));
	tir.faddr.sa_len = sizeof (struct sockaddr);
	tir.laddr.sa_len = sizeof (struct sockaddr);
	tir.faddr.sa_family = AF_INET;
	tir.laddr.sa_family = AF_INET;
	fin = (struct sockaddr_in *) &tir.faddr;
	lin = (struct sockaddr_in *) &tir.laddr;
	
	memcpy(&fin->sin_addr, faddr, sizeof (struct in_addr));
	memcpy(&lin->sin_addr, laddr, sizeof (struct in_addr));
	fin->sin_port = fport;
	lin->sin_port = lport;
	i = sizeof (tir);

	error = sysctl(mib, sizeof (mib) / sizeof (int), &tir, &i, NULL, 0);

	if (!error && tir.ruid != -1)
		return (tir.ruid);

	if (error == -1) {
		if (flags & DEBUG)
			syslog(DPRI, "sysctl failed (%m)");
	}

	return (-1);
}
