#
#
#
#

set listf_proc(insert)		listf:insert
set listf_proc(delete)		listf:delete
set listf_proc(get)		listf:get
set listf_proc(see)		listf:see
set listf_proc(entry)		listf:entry
set listf_proc(IpEntry)		listf:IpEntry
set listf_proc(MenuEntry)	listf:MenuEntry

Widget:DefineClass ListFrame LabelFrame listf:create listf:config listf_proc

# option add *ListFrame*background	\#d9d9d9
# option add *ListFrame.Button.font	-*-helvetica-bold-r-*-12-*
option add *ListFrame.addButton.text	Add
option add *ListFrame.deleteButton.text	Delete
# option add *ListFrame.upButton.text	Up
# option add *ListFrame.downButton.text	Down
option add *ListFrame.upButton.image	ImageUp
option add *ListFrame.downButton.image	ImageDown
option add *ListFrame.listbox.background	white
option add *ListFrame.listbox.disabledBackground	\#d9d9d9
option add *ListFrame.listbox.font	-*-fixed-medium-r-normal-*-14-*

proc listf:create {w a} {
    listbox $w.listbox -yscrollcommand [list $w.yscroll set]
    scrollbar $w.yscroll -orient vertical -command [list $w.listbox yview]

    button $w.addButton    -command [list listf:add_button $w.listbox $w]
    button $w.deleteButton -command [list listf:delete_button $w.listbox]
    button $w.upButton     -command [list listf:up_button $w.listbox]
    button $w.downButton   -command [list listf:down_button $w.listbox]

    frame $w.updownFrame
    lower $w.updownFrame
    pack $w.upButton $w.downButton -in $w.updownFrame -side top -fill x

    global listf_conf
    set listf_conf($w,entry) ""

    set f [$w subwidget frame]
    grid $w.listbox      -in $f -column 0 -row 1 -sticky ewns -rowspan 2
    grid $w.yscroll      -in $f -column 1 -row 1 -sticky ns   -rowspan 2
    grid $w.addButton    -in $f -column 2 -row 0 -sticky ew
    grid $w.deleteButton -in $f -column 2 -row 1 -sticky ew
    grid $w.updownFrame  -in $f -column 2 -row 2 -sticky ew

    grid columnconfigure $f 0 -weight 1
    grid rowconfigure    $f 2 -weight 1
}

proc listf:place_entry {w entry} {
    global listf_conf

    set listf_conf($w,entry) $entry
    set f [$w subwidget frame]
    grid $entry -in $f -column 0 -row 0 -sticky ew -columnspan 2
}

proc listf:set_entry {w a cmd} {
    set entry [eval $cmd $a]
    Widget:SetEntryState $entry normal
    listf:place_entry $w $entry
}

proc listf:entry     {w a} {listf:set_entry $w $a entry}
proc listf:IpEntry   {w a} {listf:set_entry $w $a IpEntry}
proc listf:MenuEntry {w a} {listf:set_entry $w $a MenuEntry}

proc listf:write_var {w varname} {
    upvar \#0 $varname var

    $w.listbox delete 0 end
    catch {
	foreach i $var {
	    $w.listbox insert end $i
	}
    }
}

proc listf:read_var {w varname} {
    upvar \#0 $varname var
    catch {
	set var [$w.listbox get 0 end]
    }
}

proc listf:config {w opt val} {
    global listf_conf

    switch -- $opt {
	-entry {
	    listf:place_entry $w $val
	}
	-width {
	    $w.listbox configure -width $val
	}
	-height {
	    $w.listbox configure -height $val
	}
	-state {
	    if {$listf_conf($w,entry) != ""} {
		Widget:SetEntryState $listf_conf($w,entry) $val
	    }
	    switch $val {
		disabled {set bg disabledBackground}
		normal -
		default {set bg background}
	    }
	    $w.listbox configure -background [option get $w.listbox $bg {}]
	}
	-variable {
	    catch {del_trace $listf_conf($w,write_id)}
	    catch {del_trace $listf_conf($w,read_id)}

	    catch {listf:write_var $w $val}
	    catch {listf:read_var $w $val}
	    set listf_conf($w,write_id) \
		[Widget:SetTrace $w $val w [list listf:write_var $w $val]]
	    set listf_conf($w,read_id) \
		[Widget:SetTrace $w $val r [list listf:read_var $w $val]]
	}
	default {
	    return 1
	}
    }
    return 0
}

proc listf:insert {w a} {
    eval $w.listbox insert $a
}

proc listf:delete {w a} {
    eval $w.listbox delete $a
}

proc listf:get {w a} {
    eval $w.listbox get $a
}

proc listf:see {w a} {
    eval $w.listbox see $a
}

proc listf:add_button {listbox w} {
    global listf_conf
    catch {
	set entry $listf_conf($w,entry)
	set val [$entry get]
	if {$val != ""} {
	    $listbox insert 0 [$entry get]
	    $entry delete 0 end
	}
    }
}

proc listf:delete_button {listbox} {
    set i [$listbox curselection]
    if {$i != ""} {
	$listbox delete $i $i
    }
}

proc listf:updown {listbox index step} {
    set s [$listbox get $index $index]
    $listbox delete $index $index
    incr index $step
    $listbox insert $index $s
    $listbox selection set $index $index
}

proc listf:up_button {listbox} {
    set i [$listbox curselection]
    if {$i != "" && $i > 0} {
	listf:updown $listbox $i -1
    }
}

proc listf:down_button {listbox} {
    set i [$listbox curselection]
    if {$i != "" && $i < [$listbox index end] - 1} {
	listf:updown $listbox $i 1
    }
}

proc listf:test {} {
    ListFrame .listf1 -width 20 -height 8
    ListFrame .listf2 -variable listf_var

    .listf1 entry .listf1.entry
    .listf2 IpEntry .listf2.entry

    button .button1 -text Print1 -command {puts [.listf1 get 0 end]}
    button .button2 -text Print2 -command {puts $listf_var}
    button .button3 -text Set2   -command {set listf_var {1111 2222 3333 4444}}
    button .button4 -text State2 -command {.listf2 configure -state disabled}

    foreach i {aho baka tawake tonma} {
	.listf1 insert end $i
    }
    grid .listf1 -column 0 -row 0 -sticky ewns -padx 10
    grid .listf2 -column 1 -row 0 -sticky ewns -columnspan 3 -padx 10
    grid .button1 -column 0 -row 1
    grid .button2 -column 1 -row 1
    grid .button3 -column 2 -row 1
    grid .button4 -column 3 -row 1

    grid columnconfigure . 0 -weight 1
    grid columnconfigure . 1 -weight 1
    grid rowconfigure . 0 -weight 1
}
